<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderDetailAllocation StructType
 * @subpackage Structs
 */
class SalesOrderDetailAllocation extends Entity
{
    /**
     * The Allocated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Allocated;
    /**
     * The AllocWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AllocWarehouseID;
    /**
     * The Completed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Completed;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The QtyOnShipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $QtyOnShipments;
    /**
     * The QtyReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $QtyReceived;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Quantity;
    /**
     * The RelatedDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RelatedDocument;
    /**
     * The ShipOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ShipOn;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for SalesOrderDetailAllocation
     * @uses SalesOrderDetailAllocation::setAllocated()
     * @uses SalesOrderDetailAllocation::setAllocWarehouseID()
     * @uses SalesOrderDetailAllocation::setCompleted()
     * @uses SalesOrderDetailAllocation::setExpirationDate()
     * @uses SalesOrderDetailAllocation::setLocationID()
     * @uses SalesOrderDetailAllocation::setLotSerialNbr()
     * @uses SalesOrderDetailAllocation::setQtyOnShipments()
     * @uses SalesOrderDetailAllocation::setQtyReceived()
     * @uses SalesOrderDetailAllocation::setQuantity()
     * @uses SalesOrderDetailAllocation::setRelatedDocument()
     * @uses SalesOrderDetailAllocation::setShipOn()
     * @uses SalesOrderDetailAllocation::setUOM()
     * @param \StructType\BooleanValue $allocated
     * @param \StructType\StringValue $allocWarehouseID
     * @param \StructType\BooleanValue $completed
     * @param \StructType\DateTimeValue $expirationDate
     * @param \StructType\StringValue $locationID
     * @param \StructType\StringValue $lotSerialNbr
     * @param \StructType\DecimalValue $qtyOnShipments
     * @param \StructType\DecimalValue $qtyReceived
     * @param \StructType\DecimalValue $quantity
     * @param \StructType\StringValue $relatedDocument
     * @param \StructType\DateTimeValue $shipOn
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\BooleanValue $allocated = null, \StructType\StringValue $allocWarehouseID = null, \StructType\BooleanValue $completed = null, \StructType\DateTimeValue $expirationDate = null, \StructType\StringValue $locationID = null, \StructType\StringValue $lotSerialNbr = null, \StructType\DecimalValue $qtyOnShipments = null, \StructType\DecimalValue $qtyReceived = null, \StructType\DecimalValue $quantity = null, \StructType\StringValue $relatedDocument = null, \StructType\DateTimeValue $shipOn = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setAllocated($allocated)
            ->setAllocWarehouseID($allocWarehouseID)
            ->setCompleted($completed)
            ->setExpirationDate($expirationDate)
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setQtyOnShipments($qtyOnShipments)
            ->setQtyReceived($qtyReceived)
            ->setQuantity($quantity)
            ->setRelatedDocument($relatedDocument)
            ->setShipOn($shipOn)
            ->setUOM($uOM);
    }
    /**
     * Get Allocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAllocated()
    {
        return isset($this->Allocated) ? $this->Allocated : null;
    }
    /**
     * Set Allocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $allocated
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setAllocated(\StructType\BooleanValue $allocated = null)
    {
        if (is_null($allocated) || (is_array($allocated) && empty($allocated))) {
            unset($this->Allocated);
        } else {
            $this->Allocated = $allocated;
        }
        return $this;
    }
    /**
     * Get AllocWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAllocWarehouseID()
    {
        return isset($this->AllocWarehouseID) ? $this->AllocWarehouseID : null;
    }
    /**
     * Set AllocWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $allocWarehouseID
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setAllocWarehouseID(\StructType\StringValue $allocWarehouseID = null)
    {
        if (is_null($allocWarehouseID) || (is_array($allocWarehouseID) && empty($allocWarehouseID))) {
            unset($this->AllocWarehouseID);
        } else {
            $this->AllocWarehouseID = $allocWarehouseID;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $completed
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setCompleted(\StructType\BooleanValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $expirationDate
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setExpirationDate(\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lotSerialNbr
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setLotSerialNbr(\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQtyOnShipments()
    {
        return isset($this->QtyOnShipments) ? $this->QtyOnShipments : null;
    }
    /**
     * Set QtyOnShipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qtyOnShipments
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setQtyOnShipments(\StructType\DecimalValue $qtyOnShipments = null)
    {
        if (is_null($qtyOnShipments) || (is_array($qtyOnShipments) && empty($qtyOnShipments))) {
            unset($this->QtyOnShipments);
        } else {
            $this->QtyOnShipments = $qtyOnShipments;
        }
        return $this;
    }
    /**
     * Get QtyReceived value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQtyReceived()
    {
        return isset($this->QtyReceived) ? $this->QtyReceived : null;
    }
    /**
     * Set QtyReceived value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qtyReceived
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setQtyReceived(\StructType\DecimalValue $qtyReceived = null)
    {
        if (is_null($qtyReceived) || (is_array($qtyReceived) && empty($qtyReceived))) {
            unset($this->QtyReceived);
        } else {
            $this->QtyReceived = $qtyReceived;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $quantity
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setQuantity(\StructType\DecimalValue $quantity = null)
    {
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RelatedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRelatedDocument()
    {
        return isset($this->RelatedDocument) ? $this->RelatedDocument : null;
    }
    /**
     * Set RelatedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $relatedDocument
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setRelatedDocument(\StructType\StringValue $relatedDocument = null)
    {
        if (is_null($relatedDocument) || (is_array($relatedDocument) && empty($relatedDocument))) {
            unset($this->RelatedDocument);
        } else {
            $this->RelatedDocument = $relatedDocument;
        }
        return $this;
    }
    /**
     * Get ShipOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getShipOn()
    {
        return isset($this->ShipOn) ? $this->ShipOn : null;
    }
    /**
     * Set ShipOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $shipOn
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setShipOn(\StructType\DateTimeValue $shipOn = null)
    {
        if (is_null($shipOn) || (is_array($shipOn) && empty($shipOn))) {
            unset($this->ShipOn);
        } else {
            $this->ShipOn = $shipOn;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\SalesOrderDetailAllocation
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesOrderDetailAllocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
