<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrder StructType
 * @subpackage Structs
 */
class PurchaseOrder extends Entity
{
    /**
     * The ControlTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ControlTotal;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Currency;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The LineTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LineTotal;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Location;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OrderTotal;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Owner;
    /**
     * The PromisedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $PromisedOn;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Vendor;
    /**
     * The VendorRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorRef;
    /**
     * Constructor method for PurchaseOrder
     * @uses PurchaseOrder::setControlTotal()
     * @uses PurchaseOrder::setCurrency()
     * @uses PurchaseOrder::setDate()
     * @uses PurchaseOrder::setDescription()
     * @uses PurchaseOrder::setDetails()
     * @uses PurchaseOrder::setHold()
     * @uses PurchaseOrder::setLineTotal()
     * @uses PurchaseOrder::setLocation()
     * @uses PurchaseOrder::setOrderNbr()
     * @uses PurchaseOrder::setOrderTotal()
     * @uses PurchaseOrder::setOwner()
     * @uses PurchaseOrder::setPromisedOn()
     * @uses PurchaseOrder::setStatus()
     * @uses PurchaseOrder::setTaxTotal()
     * @uses PurchaseOrder::setType()
     * @uses PurchaseOrder::setVendor()
     * @uses PurchaseOrder::setVendorRef()
     * @param \StructType\DecimalValue $controlTotal
     * @param \StructType\StringValue $currency
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $description
     * @param \StructType\Details $details
     * @param \StructType\BooleanValue $hold
     * @param \StructType\DecimalValue $lineTotal
     * @param \StructType\StringValue $location
     * @param \StructType\StringValue $orderNbr
     * @param \StructType\DecimalValue $orderTotal
     * @param \StructType\StringValue $owner
     * @param \StructType\DateTimeValue $promisedOn
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $taxTotal
     * @param \StructType\StringValue $type
     * @param \StructType\StringValue $vendor
     * @param \StructType\StringValue $vendorRef
     */
    public function __construct(\StructType\DecimalValue $controlTotal = null, \StructType\StringValue $currency = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $description = null, \StructType\Details $details = null, \StructType\BooleanValue $hold = null, \StructType\DecimalValue $lineTotal = null, \StructType\StringValue $location = null, \StructType\StringValue $orderNbr = null, \StructType\DecimalValue $orderTotal = null, \StructType\StringValue $owner = null, \StructType\DateTimeValue $promisedOn = null, \StructType\StringValue $status = null, \StructType\DecimalValue $taxTotal = null, \StructType\StringValue $type = null, \StructType\StringValue $vendor = null, \StructType\StringValue $vendorRef = null)
    {
        $this
            ->setControlTotal($controlTotal)
            ->setCurrency($currency)
            ->setDate($date)
            ->setDescription($description)
            ->setDetails($details)
            ->setHold($hold)
            ->setLineTotal($lineTotal)
            ->setLocation($location)
            ->setOrderNbr($orderNbr)
            ->setOrderTotal($orderTotal)
            ->setOwner($owner)
            ->setPromisedOn($promisedOn)
            ->setStatus($status)
            ->setTaxTotal($taxTotal)
            ->setType($type)
            ->setVendor($vendor)
            ->setVendorRef($vendorRef);
    }
    /**
     * Get ControlTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getControlTotal()
    {
        return isset($this->ControlTotal) ? $this->ControlTotal : null;
    }
    /**
     * Set ControlTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $controlTotal
     * @return \StructType\PurchaseOrder
     */
    public function setControlTotal(\StructType\DecimalValue $controlTotal = null)
    {
        if (is_null($controlTotal) || (is_array($controlTotal) && empty($controlTotal))) {
            unset($this->ControlTotal);
        } else {
            $this->ControlTotal = $controlTotal;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currency
     * @return \StructType\PurchaseOrder
     */
    public function setCurrency(\StructType\StringValue $currency = null)
    {
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\PurchaseOrder
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\PurchaseOrder
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\PurchaseOrder
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\PurchaseOrder
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get LineTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLineTotal()
    {
        return isset($this->LineTotal) ? $this->LineTotal : null;
    }
    /**
     * Set LineTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lineTotal
     * @return \StructType\PurchaseOrder
     */
    public function setLineTotal(\StructType\DecimalValue $lineTotal = null)
    {
        if (is_null($lineTotal) || (is_array($lineTotal) && empty($lineTotal))) {
            unset($this->LineTotal);
        } else {
            $this->LineTotal = $lineTotal;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $location
     * @return \StructType\PurchaseOrder
     */
    public function setLocation(\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderNbr
     * @return \StructType\PurchaseOrder
     */
    public function setOrderNbr(\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOrderTotal()
    {
        return isset($this->OrderTotal) ? $this->OrderTotal : null;
    }
    /**
     * Set OrderTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $orderTotal
     * @return \StructType\PurchaseOrder
     */
    public function setOrderTotal(\StructType\DecimalValue $orderTotal = null)
    {
        if (is_null($orderTotal) || (is_array($orderTotal) && empty($orderTotal))) {
            unset($this->OrderTotal);
        } else {
            $this->OrderTotal = $orderTotal;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $owner
     * @return \StructType\PurchaseOrder
     */
    public function setOwner(\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get PromisedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getPromisedOn()
    {
        return isset($this->PromisedOn) ? $this->PromisedOn : null;
    }
    /**
     * Set PromisedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $promisedOn
     * @return \StructType\PurchaseOrder
     */
    public function setPromisedOn(\StructType\DateTimeValue $promisedOn = null)
    {
        if (is_null($promisedOn) || (is_array($promisedOn) && empty($promisedOn))) {
            unset($this->PromisedOn);
        } else {
            $this->PromisedOn = $promisedOn;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\PurchaseOrder
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxTotal
     * @return \StructType\PurchaseOrder
     */
    public function setTaxTotal(\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\PurchaseOrder
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendor()
    {
        return isset($this->Vendor) ? $this->Vendor : null;
    }
    /**
     * Set Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendor
     * @return \StructType\PurchaseOrder
     */
    public function setVendor(\StructType\StringValue $vendor = null)
    {
        if (is_null($vendor) || (is_array($vendor) && empty($vendor))) {
            unset($this->Vendor);
        } else {
            $this->Vendor = $vendor;
        }
        return $this;
    }
    /**
     * Get VendorRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorRef()
    {
        return isset($this->VendorRef) ? $this->VendorRef : null;
    }
    /**
     * Set VendorRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorRef
     * @return \StructType\PurchaseOrder
     */
    public function setVendorRef(\StructType\StringValue $vendorRef = null)
    {
        if (is_null($vendorRef) || (is_array($vendorRef) && empty($vendorRef))) {
            unset($this->VendorRef);
        } else {
            $this->VendorRef = $vendorRef;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchaseOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
