<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessResult StructType
 * @subpackage Structs
 */
class ProcessResult extends AbstractStructBase
{
    /**
     * The EntityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Seconds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Seconds;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for ProcessResult
     * @uses ProcessResult::setEntityId()
     * @uses ProcessResult::setStatus()
     * @uses ProcessResult::setSeconds()
     * @uses ProcessResult::setMessage()
     * @param string $entityId
     * @param string $status
     * @param int $seconds
     * @param string $message
     */
    public function __construct($entityId = null, $status = null, $seconds = null, $message = null)
    {
        $this
            ->setEntityId($entityId)
            ->setStatus($status)
            ->setSeconds($seconds)
            ->setMessage($message);
    }
    /**
     * Get EntityId value
     * @return string
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param string $entityId
     * @return \StructType\ProcessResult
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($entityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($entityId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ProcessStatus::valueIsValid()
     * @uses \EnumType\ProcessStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ProcessResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProcessStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ProcessStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Seconds value
     * @return int
     */
    public function getSeconds()
    {
        return $this->Seconds;
    }
    /**
     * Set Seconds value
     * @param int $seconds
     * @return \StructType\ProcessResult
     */
    public function setSeconds($seconds = null)
    {
        // validation for constraint: int
        if (!is_null($seconds) && !is_numeric($seconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seconds)), __LINE__);
        }
        $this->Seconds = $seconds;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\ProcessResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
