<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalInventoryReviewDetail StructType
 * @subpackage Structs
 */
class PhysicalInventoryReviewDetail extends Entity
{
    /**
     * The BookQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BookQuantity;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The ExtVarianceCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ExtVarianceCost;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LotSerialNumber;
    /**
     * The PhysicalQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PhysicalQuantity;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The Subitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subitem;
    /**
     * The TagNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $TagNbr;
    /**
     * The UnitCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The VarianceQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $VarianceQuantity;
    /**
     * Constructor method for PhysicalInventoryReviewDetail
     * @uses PhysicalInventoryReviewDetail::setBookQuantity()
     * @uses PhysicalInventoryReviewDetail::setDescription()
     * @uses PhysicalInventoryReviewDetail::setExpirationDate()
     * @uses PhysicalInventoryReviewDetail::setExtVarianceCost()
     * @uses PhysicalInventoryReviewDetail::setInventoryID()
     * @uses PhysicalInventoryReviewDetail::setLineNbr()
     * @uses PhysicalInventoryReviewDetail::setLocationID()
     * @uses PhysicalInventoryReviewDetail::setLotSerialNumber()
     * @uses PhysicalInventoryReviewDetail::setPhysicalQuantity()
     * @uses PhysicalInventoryReviewDetail::setReasonCode()
     * @uses PhysicalInventoryReviewDetail::setStatus()
     * @uses PhysicalInventoryReviewDetail::setSubitem()
     * @uses PhysicalInventoryReviewDetail::setTagNbr()
     * @uses PhysicalInventoryReviewDetail::setUnitCost()
     * @uses PhysicalInventoryReviewDetail::setVarianceQuantity()
     * @param \StructType\DecimalValue $bookQuantity
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $expirationDate
     * @param \StructType\DecimalValue $extVarianceCost
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\StringValue $locationID
     * @param \StructType\StringValue $lotSerialNumber
     * @param \StructType\DecimalValue $physicalQuantity
     * @param \StructType\StringValue $reasonCode
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $subitem
     * @param \StructType\IntValue $tagNbr
     * @param \StructType\DecimalValue $unitCost
     * @param \StructType\DecimalValue $varianceQuantity
     */
    public function __construct(\StructType\DecimalValue $bookQuantity = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $expirationDate = null, \StructType\DecimalValue $extVarianceCost = null, \StructType\StringValue $inventoryID = null, \StructType\IntValue $lineNbr = null, \StructType\StringValue $locationID = null, \StructType\StringValue $lotSerialNumber = null, \StructType\DecimalValue $physicalQuantity = null, \StructType\StringValue $reasonCode = null, \StructType\StringValue $status = null, \StructType\StringValue $subitem = null, \StructType\IntValue $tagNbr = null, \StructType\DecimalValue $unitCost = null, \StructType\DecimalValue $varianceQuantity = null)
    {
        $this
            ->setBookQuantity($bookQuantity)
            ->setDescription($description)
            ->setExpirationDate($expirationDate)
            ->setExtVarianceCost($extVarianceCost)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setLocationID($locationID)
            ->setLotSerialNumber($lotSerialNumber)
            ->setPhysicalQuantity($physicalQuantity)
            ->setReasonCode($reasonCode)
            ->setStatus($status)
            ->setSubitem($subitem)
            ->setTagNbr($tagNbr)
            ->setUnitCost($unitCost)
            ->setVarianceQuantity($varianceQuantity);
    }
    /**
     * Get BookQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBookQuantity()
    {
        return isset($this->BookQuantity) ? $this->BookQuantity : null;
    }
    /**
     * Set BookQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $bookQuantity
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setBookQuantity(\StructType\DecimalValue $bookQuantity = null)
    {
        if (is_null($bookQuantity) || (is_array($bookQuantity) && empty($bookQuantity))) {
            unset($this->BookQuantity);
        } else {
            $this->BookQuantity = $bookQuantity;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $expirationDate
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setExpirationDate(\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get ExtVarianceCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getExtVarianceCost()
    {
        return isset($this->ExtVarianceCost) ? $this->ExtVarianceCost : null;
    }
    /**
     * Set ExtVarianceCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $extVarianceCost
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setExtVarianceCost(\StructType\DecimalValue $extVarianceCost = null)
    {
        if (is_null($extVarianceCost) || (is_array($extVarianceCost) && empty($extVarianceCost))) {
            unset($this->ExtVarianceCost);
        } else {
            $this->ExtVarianceCost = $extVarianceCost;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLotSerialNumber()
    {
        return isset($this->LotSerialNumber) ? $this->LotSerialNumber : null;
    }
    /**
     * Set LotSerialNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lotSerialNumber
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setLotSerialNumber(\StructType\StringValue $lotSerialNumber = null)
    {
        if (is_null($lotSerialNumber) || (is_array($lotSerialNumber) && empty($lotSerialNumber))) {
            unset($this->LotSerialNumber);
        } else {
            $this->LotSerialNumber = $lotSerialNumber;
        }
        return $this;
    }
    /**
     * Get PhysicalQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPhysicalQuantity()
    {
        return isset($this->PhysicalQuantity) ? $this->PhysicalQuantity : null;
    }
    /**
     * Set PhysicalQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $physicalQuantity
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setPhysicalQuantity(\StructType\DecimalValue $physicalQuantity = null)
    {
        if (is_null($physicalQuantity) || (is_array($physicalQuantity) && empty($physicalQuantity))) {
            unset($this->PhysicalQuantity);
        } else {
            $this->PhysicalQuantity = $physicalQuantity;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reasonCode
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setReasonCode(\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subitem
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setSubitem(\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TagNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getTagNbr()
    {
        return isset($this->TagNbr) ? $this->TagNbr : null;
    }
    /**
     * Set TagNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $tagNbr
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setTagNbr(\StructType\IntValue $tagNbr = null)
    {
        if (is_null($tagNbr) || (is_array($tagNbr) && empty($tagNbr))) {
            unset($this->TagNbr);
        } else {
            $this->TagNbr = $tagNbr;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitCost
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setUnitCost(\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get VarianceQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVarianceQuantity()
    {
        return isset($this->VarianceQuantity) ? $this->VarianceQuantity : null;
    }
    /**
     * Set VarianceQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $varianceQuantity
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setVarianceQuantity(\StructType\DecimalValue $varianceQuantity = null)
    {
        if (is_null($varianceQuantity) || (is_array($varianceQuantity) && empty($varianceQuantity))) {
            unset($this->VarianceQuantity);
        } else {
            $this->VarianceQuantity = $varianceQuantity;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
