<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersToApply StructType
 * @subpackage Structs
 */
class OrdersToApply extends AbstractStructBase
{
    /**
     * The PaymentOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentOrder[]
     */
    public $PaymentOrder;
    /**
     * Constructor method for OrdersToApply
     * @uses OrdersToApply::setPaymentOrder()
     * @param \StructType\PaymentOrder[] $paymentOrder
     */
    public function __construct(array $paymentOrder = array())
    {
        $this
            ->setPaymentOrder($paymentOrder);
    }
    /**
     * Get PaymentOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentOrder[]|null
     */
    public function getPaymentOrder()
    {
        return isset($this->PaymentOrder) ? $this->PaymentOrder : null;
    }
    /**
     * Set PaymentOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentOrder[] $paymentOrder
     * @return \StructType\OrdersToApply
     */
    public function setPaymentOrder(array $paymentOrder = array())
    {
        foreach ($paymentOrder as $ordersToApplyPaymentOrderItem) {
            // validation for constraint: itemType
            if (!$ordersToApplyPaymentOrderItem instanceof \StructType\PaymentOrder) {
                throw new \InvalidArgumentException(sprintf('The PaymentOrder property can only contain items of \StructType\PaymentOrder, "%s" given', is_object($ordersToApplyPaymentOrderItem) ? get_class($ordersToApplyPaymentOrderItem) : gettype($ordersToApplyPaymentOrderItem)), __LINE__);
            }
        }
        if (is_null($paymentOrder) || (is_array($paymentOrder) && empty($paymentOrder))) {
            unset($this->PaymentOrder);
        } else {
            $this->PaymentOrder = $paymentOrder;
        }
        return $this;
    }
    /**
     * Add item to PaymentOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentOrder $item
     * @return \StructType\OrdersToApply
     */
    public function addToPaymentOrder(\StructType\PaymentOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentOrder) {
            throw new \InvalidArgumentException(sprintf('The PaymentOrder property can only contain items of \StructType\PaymentOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentOrder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrdersToApply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
