<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Locations StructType
 * @subpackage Structs
 */
class Locations extends AbstractStructBase
{
    /**
     * The WarehouseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WarehouseLocation[]
     */
    public $WarehouseLocation;
    /**
     * Constructor method for Locations
     * @uses Locations::setWarehouseLocation()
     * @param \StructType\WarehouseLocation[] $warehouseLocation
     */
    public function __construct(array $warehouseLocation = array())
    {
        $this
            ->setWarehouseLocation($warehouseLocation);
    }
    /**
     * Get WarehouseLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WarehouseLocation[]|null
     */
    public function getWarehouseLocation()
    {
        return isset($this->WarehouseLocation) ? $this->WarehouseLocation : null;
    }
    /**
     * Set WarehouseLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseLocation[] $warehouseLocation
     * @return \StructType\Locations
     */
    public function setWarehouseLocation(array $warehouseLocation = array())
    {
        foreach ($warehouseLocation as $locationsWarehouseLocationItem) {
            // validation for constraint: itemType
            if (!$locationsWarehouseLocationItem instanceof \StructType\WarehouseLocation) {
                throw new \InvalidArgumentException(sprintf('The WarehouseLocation property can only contain items of \StructType\WarehouseLocation, "%s" given', is_object($locationsWarehouseLocationItem) ? get_class($locationsWarehouseLocationItem) : gettype($locationsWarehouseLocationItem)), __LINE__);
            }
        }
        if (is_null($warehouseLocation) || (is_array($warehouseLocation) && empty($warehouseLocation))) {
            unset($this->WarehouseLocation);
        } else {
            $this->WarehouseLocation = $warehouseLocation;
        }
        return $this;
    }
    /**
     * Add item to WarehouseLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseLocation $item
     * @return \StructType\Locations
     */
    public function addToWarehouseLocation(\StructType\WarehouseLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarehouseLocation) {
            throw new \InvalidArgumentException(sprintf('The WarehouseLocation property can only contain items of \StructType\WarehouseLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarehouseLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Locations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
