<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitSpecification StructType
 * @subpackage Structs
 */
class KitSpecification extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The KitInventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $KitInventoryID;
    /**
     * The NonStock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $NonStock;
    /**
     * The NonStockComponents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NonStockComponents
     */
    public $NonStockComponents;
    /**
     * The Revision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Revision;
    /**
     * The StockComponents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockComponents
     */
    public $StockComponents;
    /**
     * Constructor method for KitSpecification
     * @uses KitSpecification::setActive()
     * @uses KitSpecification::setDescription()
     * @uses KitSpecification::setKitInventoryID()
     * @uses KitSpecification::setNonStock()
     * @uses KitSpecification::setNonStockComponents()
     * @uses KitSpecification::setRevision()
     * @uses KitSpecification::setStockComponents()
     * @param \StructType\BooleanValue $active
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $kitInventoryID
     * @param \StructType\BooleanValue $nonStock
     * @param \StructType\NonStockComponents $nonStockComponents
     * @param \StructType\StringValue $revision
     * @param \StructType\StockComponents $stockComponents
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\StringValue $description = null, \StructType\StringValue $kitInventoryID = null, \StructType\BooleanValue $nonStock = null, \StructType\NonStockComponents $nonStockComponents = null, \StructType\StringValue $revision = null, \StructType\StockComponents $stockComponents = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setKitInventoryID($kitInventoryID)
            ->setNonStock($nonStock)
            ->setNonStockComponents($nonStockComponents)
            ->setRevision($revision)
            ->setStockComponents($stockComponents);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\KitSpecification
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\KitSpecification
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get KitInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getKitInventoryID()
    {
        return isset($this->KitInventoryID) ? $this->KitInventoryID : null;
    }
    /**
     * Set KitInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $kitInventoryID
     * @return \StructType\KitSpecification
     */
    public function setKitInventoryID(\StructType\StringValue $kitInventoryID = null)
    {
        if (is_null($kitInventoryID) || (is_array($kitInventoryID) && empty($kitInventoryID))) {
            unset($this->KitInventoryID);
        } else {
            $this->KitInventoryID = $kitInventoryID;
        }
        return $this;
    }
    /**
     * Get NonStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getNonStock()
    {
        return isset($this->NonStock) ? $this->NonStock : null;
    }
    /**
     * Set NonStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $nonStock
     * @return \StructType\KitSpecification
     */
    public function setNonStock(\StructType\BooleanValue $nonStock = null)
    {
        if (is_null($nonStock) || (is_array($nonStock) && empty($nonStock))) {
            unset($this->NonStock);
        } else {
            $this->NonStock = $nonStock;
        }
        return $this;
    }
    /**
     * Get NonStockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NonStockComponents|null
     */
    public function getNonStockComponents()
    {
        return isset($this->NonStockComponents) ? $this->NonStockComponents : null;
    }
    /**
     * Set NonStockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\NonStockComponents $nonStockComponents
     * @return \StructType\KitSpecification
     */
    public function setNonStockComponents(\StructType\NonStockComponents $nonStockComponents = null)
    {
        if (is_null($nonStockComponents) || (is_array($nonStockComponents) && empty($nonStockComponents))) {
            unset($this->NonStockComponents);
        } else {
            $this->NonStockComponents = $nonStockComponents;
        }
        return $this;
    }
    /**
     * Get Revision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRevision()
    {
        return isset($this->Revision) ? $this->Revision : null;
    }
    /**
     * Set Revision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $revision
     * @return \StructType\KitSpecification
     */
    public function setRevision(\StructType\StringValue $revision = null)
    {
        if (is_null($revision) || (is_array($revision) && empty($revision))) {
            unset($this->Revision);
        } else {
            $this->Revision = $revision;
        }
        return $this;
    }
    /**
     * Get StockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockComponents|null
     */
    public function getStockComponents()
    {
        return isset($this->StockComponents) ? $this->StockComponents : null;
    }
    /**
     * Set StockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StockComponents $stockComponents
     * @return \StructType\KitSpecification
     */
    public function setStockComponents(\StructType\StockComponents $stockComponents = null)
    {
        if (is_null($stockComponents) || (is_array($stockComponents) && empty($stockComponents))) {
            unset($this->StockComponents);
        } else {
            $this->StockComponents = $stockComponents;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KitSpecification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
