<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitNonStockComponent StructType
 * @subpackage Structs
 */
class KitNonStockComponent extends Entity
{
    /**
     * The AllowComponentQtyVariance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AllowComponentQtyVariance;
    /**
     * The ComponentQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ComponentQty;
    /**
     * The MaxComponentQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxComponentQty;
    /**
     * The MinComponentQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MinComponentQty;
    /**
     * The NonStockInventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $NonStockInventoryID;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for KitNonStockComponent
     * @uses KitNonStockComponent::setAllowComponentQtyVariance()
     * @uses KitNonStockComponent::setComponentQty()
     * @uses KitNonStockComponent::setMaxComponentQty()
     * @uses KitNonStockComponent::setMinComponentQty()
     * @uses KitNonStockComponent::setNonStockInventoryID()
     * @uses KitNonStockComponent::setUOM()
     * @param \StructType\BooleanValue $allowComponentQtyVariance
     * @param \StructType\DecimalValue $componentQty
     * @param \StructType\DecimalValue $maxComponentQty
     * @param \StructType\DecimalValue $minComponentQty
     * @param \StructType\StringValue $nonStockInventoryID
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\BooleanValue $allowComponentQtyVariance = null, \StructType\DecimalValue $componentQty = null, \StructType\DecimalValue $maxComponentQty = null, \StructType\DecimalValue $minComponentQty = null, \StructType\StringValue $nonStockInventoryID = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setAllowComponentQtyVariance($allowComponentQtyVariance)
            ->setComponentQty($componentQty)
            ->setMaxComponentQty($maxComponentQty)
            ->setMinComponentQty($minComponentQty)
            ->setNonStockInventoryID($nonStockInventoryID)
            ->setUOM($uOM);
    }
    /**
     * Get AllowComponentQtyVariance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAllowComponentQtyVariance()
    {
        return isset($this->AllowComponentQtyVariance) ? $this->AllowComponentQtyVariance : null;
    }
    /**
     * Set AllowComponentQtyVariance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $allowComponentQtyVariance
     * @return \StructType\KitNonStockComponent
     */
    public function setAllowComponentQtyVariance(\StructType\BooleanValue $allowComponentQtyVariance = null)
    {
        if (is_null($allowComponentQtyVariance) || (is_array($allowComponentQtyVariance) && empty($allowComponentQtyVariance))) {
            unset($this->AllowComponentQtyVariance);
        } else {
            $this->AllowComponentQtyVariance = $allowComponentQtyVariance;
        }
        return $this;
    }
    /**
     * Get ComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getComponentQty()
    {
        return isset($this->ComponentQty) ? $this->ComponentQty : null;
    }
    /**
     * Set ComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $componentQty
     * @return \StructType\KitNonStockComponent
     */
    public function setComponentQty(\StructType\DecimalValue $componentQty = null)
    {
        if (is_null($componentQty) || (is_array($componentQty) && empty($componentQty))) {
            unset($this->ComponentQty);
        } else {
            $this->ComponentQty = $componentQty;
        }
        return $this;
    }
    /**
     * Get MaxComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxComponentQty()
    {
        return isset($this->MaxComponentQty) ? $this->MaxComponentQty : null;
    }
    /**
     * Set MaxComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxComponentQty
     * @return \StructType\KitNonStockComponent
     */
    public function setMaxComponentQty(\StructType\DecimalValue $maxComponentQty = null)
    {
        if (is_null($maxComponentQty) || (is_array($maxComponentQty) && empty($maxComponentQty))) {
            unset($this->MaxComponentQty);
        } else {
            $this->MaxComponentQty = $maxComponentQty;
        }
        return $this;
    }
    /**
     * Get MinComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMinComponentQty()
    {
        return isset($this->MinComponentQty) ? $this->MinComponentQty : null;
    }
    /**
     * Set MinComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $minComponentQty
     * @return \StructType\KitNonStockComponent
     */
    public function setMinComponentQty(\StructType\DecimalValue $minComponentQty = null)
    {
        if (is_null($minComponentQty) || (is_array($minComponentQty) && empty($minComponentQty))) {
            unset($this->MinComponentQty);
        } else {
            $this->MinComponentQty = $minComponentQty;
        }
        return $this;
    }
    /**
     * Get NonStockInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getNonStockInventoryID()
    {
        return isset($this->NonStockInventoryID) ? $this->NonStockInventoryID : null;
    }
    /**
     * Set NonStockInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $nonStockInventoryID
     * @return \StructType\KitNonStockComponent
     */
    public function setNonStockInventoryID(\StructType\StringValue $nonStockInventoryID = null)
    {
        if (is_null($nonStockInventoryID) || (is_array($nonStockInventoryID) && empty($nonStockInventoryID))) {
            unset($this->NonStockInventoryID);
        } else {
            $this->NonStockInventoryID = $nonStockInventoryID;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\KitNonStockComponent
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KitNonStockComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
