<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitAssemblyNonStockComponent StructType
 * @subpackage Structs
 */
class KitAssemblyNonStockComponent extends Entity
{
    /**
     * The ComponentQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ComponentQty;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The NonStockInventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $NonStockInventoryID;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Qty;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The UnitCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for KitAssemblyNonStockComponent
     * @uses KitAssemblyNonStockComponent::setComponentQty()
     * @uses KitAssemblyNonStockComponent::setLineNbr()
     * @uses KitAssemblyNonStockComponent::setNonStockInventoryID()
     * @uses KitAssemblyNonStockComponent::setQty()
     * @uses KitAssemblyNonStockComponent::setReasonCode()
     * @uses KitAssemblyNonStockComponent::setUnitCost()
     * @uses KitAssemblyNonStockComponent::setUOM()
     * @param \StructType\DecimalValue $componentQty
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\StringValue $nonStockInventoryID
     * @param \StructType\DecimalValue $qty
     * @param \StructType\StringValue $reasonCode
     * @param \StructType\DecimalValue $unitCost
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\DecimalValue $componentQty = null, \StructType\IntValue $lineNbr = null, \StructType\StringValue $nonStockInventoryID = null, \StructType\DecimalValue $qty = null, \StructType\StringValue $reasonCode = null, \StructType\DecimalValue $unitCost = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setComponentQty($componentQty)
            ->setLineNbr($lineNbr)
            ->setNonStockInventoryID($nonStockInventoryID)
            ->setQty($qty)
            ->setReasonCode($reasonCode)
            ->setUnitCost($unitCost)
            ->setUOM($uOM);
    }
    /**
     * Get ComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getComponentQty()
    {
        return isset($this->ComponentQty) ? $this->ComponentQty : null;
    }
    /**
     * Set ComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $componentQty
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setComponentQty(\StructType\DecimalValue $componentQty = null)
    {
        if (is_null($componentQty) || (is_array($componentQty) && empty($componentQty))) {
            unset($this->ComponentQty);
        } else {
            $this->ComponentQty = $componentQty;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get NonStockInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getNonStockInventoryID()
    {
        return isset($this->NonStockInventoryID) ? $this->NonStockInventoryID : null;
    }
    /**
     * Set NonStockInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $nonStockInventoryID
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setNonStockInventoryID(\StructType\StringValue $nonStockInventoryID = null)
    {
        if (is_null($nonStockInventoryID) || (is_array($nonStockInventoryID) && empty($nonStockInventoryID))) {
            unset($this->NonStockInventoryID);
        } else {
            $this->NonStockInventoryID = $nonStockInventoryID;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qty
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setQty(\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reasonCode
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setReasonCode(\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitCost
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setUnitCost(\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KitAssemblyNonStockComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
