<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoke StructType
 * @subpackage Structs
 */
class Invoke extends AbstractStructBase
{
    /**
     * The entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Entity
     */
    public $entity;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Action
     */
    public $action;
    /**
     * Constructor method for Invoke
     * @uses Invoke::setEntity()
     * @uses Invoke::setAction()
     * @param \StructType\Entity $entity
     * @param \StructType\Action $action
     */
    public function __construct(\StructType\Entity $entity = null, \StructType\Action $action = null)
    {
        $this
            ->setEntity($entity)
            ->setAction($action);
    }
    /**
     * Get entity value
     * @return \StructType\Entity|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\Entity $entity
     * @return \StructType\Invoke
     */
    public function setEntity(\StructType\Entity $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get action value
     * @return \StructType\Action|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param \StructType\Action $action
     * @return \StructType\Invoke
     */
    public function setAction(\StructType\Action $action = null)
    {
        $this->action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invoke
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
