<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemUOMConversion StructType
 * @subpackage Structs
 */
class InventoryItemUOMConversion extends Entity
{
    /**
     * The ConversionFactor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ConversionFactor;
    /**
     * The FromUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FromUOM;
    /**
     * The MultiplyDivide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $MultiplyDivide;
    /**
     * The ToUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ToUOM;
    /**
     * Constructor method for InventoryItemUOMConversion
     * @uses InventoryItemUOMConversion::setConversionFactor()
     * @uses InventoryItemUOMConversion::setFromUOM()
     * @uses InventoryItemUOMConversion::setMultiplyDivide()
     * @uses InventoryItemUOMConversion::setToUOM()
     * @param \StructType\DecimalValue $conversionFactor
     * @param \StructType\StringValue $fromUOM
     * @param \StructType\StringValue $multiplyDivide
     * @param \StructType\StringValue $toUOM
     */
    public function __construct(\StructType\DecimalValue $conversionFactor = null, \StructType\StringValue $fromUOM = null, \StructType\StringValue $multiplyDivide = null, \StructType\StringValue $toUOM = null)
    {
        $this
            ->setConversionFactor($conversionFactor)
            ->setFromUOM($fromUOM)
            ->setMultiplyDivide($multiplyDivide)
            ->setToUOM($toUOM);
    }
    /**
     * Get ConversionFactor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getConversionFactor()
    {
        return isset($this->ConversionFactor) ? $this->ConversionFactor : null;
    }
    /**
     * Set ConversionFactor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $conversionFactor
     * @return \StructType\InventoryItemUOMConversion
     */
    public function setConversionFactor(\StructType\DecimalValue $conversionFactor = null)
    {
        if (is_null($conversionFactor) || (is_array($conversionFactor) && empty($conversionFactor))) {
            unset($this->ConversionFactor);
        } else {
            $this->ConversionFactor = $conversionFactor;
        }
        return $this;
    }
    /**
     * Get FromUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFromUOM()
    {
        return isset($this->FromUOM) ? $this->FromUOM : null;
    }
    /**
     * Set FromUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $fromUOM
     * @return \StructType\InventoryItemUOMConversion
     */
    public function setFromUOM(\StructType\StringValue $fromUOM = null)
    {
        if (is_null($fromUOM) || (is_array($fromUOM) && empty($fromUOM))) {
            unset($this->FromUOM);
        } else {
            $this->FromUOM = $fromUOM;
        }
        return $this;
    }
    /**
     * Get MultiplyDivide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getMultiplyDivide()
    {
        return isset($this->MultiplyDivide) ? $this->MultiplyDivide : null;
    }
    /**
     * Set MultiplyDivide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $multiplyDivide
     * @return \StructType\InventoryItemUOMConversion
     */
    public function setMultiplyDivide(\StructType\StringValue $multiplyDivide = null)
    {
        if (is_null($multiplyDivide) || (is_array($multiplyDivide) && empty($multiplyDivide))) {
            unset($this->MultiplyDivide);
        } else {
            $this->MultiplyDivide = $multiplyDivide;
        }
        return $this;
    }
    /**
     * Get ToUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getToUOM()
    {
        return isset($this->ToUOM) ? $this->ToUOM : null;
    }
    /**
     * Set ToUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $toUOM
     * @return \StructType\InventoryItemUOMConversion
     */
    public function setToUOM(\StructType\StringValue $toUOM = null)
    {
        if (is_null($toUOM) || (is_array($toUOM) && empty($toUOM))) {
            unset($this->ToUOM);
        } else {
            $this->ToUOM = $toUOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryItemUOMConversion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
