<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryAllocationInquiry StructType
 * @subpackage Structs
 */
class InventoryAllocationInquiry extends Entity
{
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The OnHand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OnHand;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for InventoryAllocationInquiry
     * @uses InventoryAllocationInquiry::setInventoryID()
     * @uses InventoryAllocationInquiry::setOnHand()
     * @uses InventoryAllocationInquiry::setWarehouseID()
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\DecimalValue $onHand
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\StringValue $inventoryID = null, \StructType\DecimalValue $onHand = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setInventoryID($inventoryID)
            ->setOnHand($onHand)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get OnHand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOnHand()
    {
        return isset($this->OnHand) ? $this->OnHand : null;
    }
    /**
     * Set OnHand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $onHand
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setOnHand(\StructType\DecimalValue $onHand = null)
    {
        if (is_null($onHand) || (is_array($onHand) && empty($onHand))) {
            unset($this->OnHand);
        } else {
            $this->OnHand = $onHand;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\InventoryAllocationInquiry
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryAllocationInquiry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
