<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends Entity
{
    /**
     * The AccountRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountRef;
    /**
     * The ApplyOverdueCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ApplyOverdueCharges;
    /**
     * The AutoApplyPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AutoApplyPayments;
    /**
     * The BillingAddressSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $BillingAddressSameAsMain;
    /**
     * The BillingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $BillingContact;
    /**
     * The BillingContactSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $BillingContactSameAsMain;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contacts
     */
    public $Contacts;
    /**
     * The CreditDaysPastDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $CreditDaysPastDue;
    /**
     * The CreditLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CreditLimit;
    /**
     * The CreditVerification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CreditVerification;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CustomerClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerClass;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerName;
    /**
     * The EnableWriteOffs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $EnableWriteOffs;
    /**
     * The FirstInvoiceDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $FirstInvoiceDate;
    /**
     * The FOBPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The LastModified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModified;
    /**
     * The LeadTimedays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $LeadTimedays;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationName;
    /**
     * The MainContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $MainContact;
    /**
     * The OpenOrdersBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OpenOrdersBalance;
    /**
     * The OrderPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $OrderPriority;
    /**
     * The ParentRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ParentRecord;
    /**
     * The PriceClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PriceClassID;
    /**
     * The PrintInvoices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $PrintInvoices;
    /**
     * The PrintStatements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $PrintStatements;
    /**
     * The RemainingCreditLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RemainingCreditLimit;
    /**
     * The ResidentialDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The SaturdayDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The SendInvoicesbyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SendInvoicesbyEmail;
    /**
     * The SendStatementsbyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SendStatementsbyEmail;
    /**
     * The ShippingAddressSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShippingAddressSameAsMain;
    /**
     * The ShippingBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingBranch;
    /**
     * The ShippingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $ShippingContact;
    /**
     * The ShippingContactSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShippingContactSameAsMain;
    /**
     * The ShippingRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZoneID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingZoneID;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipVia;
    /**
     * The StatementCycleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StatementCycleID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxRegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Terms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Terms;
    /**
     * The UnreleasedBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnreleasedBalance;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * The WriteOffLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $WriteOffLimit;
    /**
     * Constructor method for Customer
     * @uses Customer::setAccountRef()
     * @uses Customer::setApplyOverdueCharges()
     * @uses Customer::setAutoApplyPayments()
     * @uses Customer::setBillingAddressSameAsMain()
     * @uses Customer::setBillingContact()
     * @uses Customer::setBillingContactSameAsMain()
     * @uses Customer::setContacts()
     * @uses Customer::setCreditDaysPastDue()
     * @uses Customer::setCreditLimit()
     * @uses Customer::setCreditVerification()
     * @uses Customer::setCurrencyID()
     * @uses Customer::setCustomerClass()
     * @uses Customer::setCustomerID()
     * @uses Customer::setCustomerName()
     * @uses Customer::setEnableWriteOffs()
     * @uses Customer::setFirstInvoiceDate()
     * @uses Customer::setFOBPoint()
     * @uses Customer::setLastModified()
     * @uses Customer::setLeadTimedays()
     * @uses Customer::setLocationName()
     * @uses Customer::setMainContact()
     * @uses Customer::setOpenOrdersBalance()
     * @uses Customer::setOrderPriority()
     * @uses Customer::setParentRecord()
     * @uses Customer::setPriceClassID()
     * @uses Customer::setPrintInvoices()
     * @uses Customer::setPrintStatements()
     * @uses Customer::setRemainingCreditLimit()
     * @uses Customer::setResidentialDelivery()
     * @uses Customer::setSaturdayDelivery()
     * @uses Customer::setSendInvoicesbyEmail()
     * @uses Customer::setSendStatementsbyEmail()
     * @uses Customer::setShippingAddressSameAsMain()
     * @uses Customer::setShippingBranch()
     * @uses Customer::setShippingContact()
     * @uses Customer::setShippingContactSameAsMain()
     * @uses Customer::setShippingRule()
     * @uses Customer::setShippingTerms()
     * @uses Customer::setShippingZoneID()
     * @uses Customer::setShipVia()
     * @uses Customer::setStatementCycleID()
     * @uses Customer::setStatus()
     * @uses Customer::setTaxRegistrationID()
     * @uses Customer::setTaxZone()
     * @uses Customer::setTerms()
     * @uses Customer::setUnreleasedBalance()
     * @uses Customer::setWarehouseID()
     * @uses Customer::setWriteOffLimit()
     * @param \StructType\StringValue $accountRef
     * @param \StructType\BooleanValue $applyOverdueCharges
     * @param \StructType\BooleanValue $autoApplyPayments
     * @param \StructType\BooleanValue $billingAddressSameAsMain
     * @param \StructType\Contact $billingContact
     * @param \StructType\BooleanValue $billingContactSameAsMain
     * @param \StructType\Contacts $contacts
     * @param \StructType\ShortValue $creditDaysPastDue
     * @param \StructType\DecimalValue $creditLimit
     * @param \StructType\StringValue $creditVerification
     * @param \StructType\StringValue $currencyID
     * @param \StructType\StringValue $customerClass
     * @param \StructType\StringValue $customerID
     * @param \StructType\StringValue $customerName
     * @param \StructType\BooleanValue $enableWriteOffs
     * @param \StructType\DateTimeValue $firstInvoiceDate
     * @param \StructType\StringValue $fOBPoint
     * @param \StructType\DateTimeValue $lastModified
     * @param \StructType\ShortValue $leadTimedays
     * @param \StructType\StringValue $locationName
     * @param \StructType\Contact $mainContact
     * @param \StructType\DecimalValue $openOrdersBalance
     * @param \StructType\ShortValue $orderPriority
     * @param \StructType\StringValue $parentRecord
     * @param \StructType\StringValue $priceClassID
     * @param \StructType\BooleanValue $printInvoices
     * @param \StructType\BooleanValue $printStatements
     * @param \StructType\DecimalValue $remainingCreditLimit
     * @param \StructType\BooleanValue $residentialDelivery
     * @param \StructType\BooleanValue $saturdayDelivery
     * @param \StructType\BooleanValue $sendInvoicesbyEmail
     * @param \StructType\BooleanValue $sendStatementsbyEmail
     * @param \StructType\BooleanValue $shippingAddressSameAsMain
     * @param \StructType\StringValue $shippingBranch
     * @param \StructType\Contact $shippingContact
     * @param \StructType\BooleanValue $shippingContactSameAsMain
     * @param \StructType\StringValue $shippingRule
     * @param \StructType\StringValue $shippingTerms
     * @param \StructType\StringValue $shippingZoneID
     * @param \StructType\StringValue $shipVia
     * @param \StructType\StringValue $statementCycleID
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $taxRegistrationID
     * @param \StructType\StringValue $taxZone
     * @param \StructType\StringValue $terms
     * @param \StructType\DecimalValue $unreleasedBalance
     * @param \StructType\StringValue $warehouseID
     * @param \StructType\DecimalValue $writeOffLimit
     */
    public function __construct(\StructType\StringValue $accountRef = null, \StructType\BooleanValue $applyOverdueCharges = null, \StructType\BooleanValue $autoApplyPayments = null, \StructType\BooleanValue $billingAddressSameAsMain = null, \StructType\Contact $billingContact = null, \StructType\BooleanValue $billingContactSameAsMain = null, \StructType\Contacts $contacts = null, \StructType\ShortValue $creditDaysPastDue = null, \StructType\DecimalValue $creditLimit = null, \StructType\StringValue $creditVerification = null, \StructType\StringValue $currencyID = null, \StructType\StringValue $customerClass = null, \StructType\StringValue $customerID = null, \StructType\StringValue $customerName = null, \StructType\BooleanValue $enableWriteOffs = null, \StructType\DateTimeValue $firstInvoiceDate = null, \StructType\StringValue $fOBPoint = null, \StructType\DateTimeValue $lastModified = null, \StructType\ShortValue $leadTimedays = null, \StructType\StringValue $locationName = null, \StructType\Contact $mainContact = null, \StructType\DecimalValue $openOrdersBalance = null, \StructType\ShortValue $orderPriority = null, \StructType\StringValue $parentRecord = null, \StructType\StringValue $priceClassID = null, \StructType\BooleanValue $printInvoices = null, \StructType\BooleanValue $printStatements = null, \StructType\DecimalValue $remainingCreditLimit = null, \StructType\BooleanValue $residentialDelivery = null, \StructType\BooleanValue $saturdayDelivery = null, \StructType\BooleanValue $sendInvoicesbyEmail = null, \StructType\BooleanValue $sendStatementsbyEmail = null, \StructType\BooleanValue $shippingAddressSameAsMain = null, \StructType\StringValue $shippingBranch = null, \StructType\Contact $shippingContact = null, \StructType\BooleanValue $shippingContactSameAsMain = null, \StructType\StringValue $shippingRule = null, \StructType\StringValue $shippingTerms = null, \StructType\StringValue $shippingZoneID = null, \StructType\StringValue $shipVia = null, \StructType\StringValue $statementCycleID = null, \StructType\StringValue $status = null, \StructType\StringValue $taxRegistrationID = null, \StructType\StringValue $taxZone = null, \StructType\StringValue $terms = null, \StructType\DecimalValue $unreleasedBalance = null, \StructType\StringValue $warehouseID = null, \StructType\DecimalValue $writeOffLimit = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setApplyOverdueCharges($applyOverdueCharges)
            ->setAutoApplyPayments($autoApplyPayments)
            ->setBillingAddressSameAsMain($billingAddressSameAsMain)
            ->setBillingContact($billingContact)
            ->setBillingContactSameAsMain($billingContactSameAsMain)
            ->setContacts($contacts)
            ->setCreditDaysPastDue($creditDaysPastDue)
            ->setCreditLimit($creditLimit)
            ->setCreditVerification($creditVerification)
            ->setCurrencyID($currencyID)
            ->setCustomerClass($customerClass)
            ->setCustomerID($customerID)
            ->setCustomerName($customerName)
            ->setEnableWriteOffs($enableWriteOffs)
            ->setFirstInvoiceDate($firstInvoiceDate)
            ->setFOBPoint($fOBPoint)
            ->setLastModified($lastModified)
            ->setLeadTimedays($leadTimedays)
            ->setLocationName($locationName)
            ->setMainContact($mainContact)
            ->setOpenOrdersBalance($openOrdersBalance)
            ->setOrderPriority($orderPriority)
            ->setParentRecord($parentRecord)
            ->setPriceClassID($priceClassID)
            ->setPrintInvoices($printInvoices)
            ->setPrintStatements($printStatements)
            ->setRemainingCreditLimit($remainingCreditLimit)
            ->setResidentialDelivery($residentialDelivery)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setSendInvoicesbyEmail($sendInvoicesbyEmail)
            ->setSendStatementsbyEmail($sendStatementsbyEmail)
            ->setShippingAddressSameAsMain($shippingAddressSameAsMain)
            ->setShippingBranch($shippingBranch)
            ->setShippingContact($shippingContact)
            ->setShippingContactSameAsMain($shippingContactSameAsMain)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZoneID($shippingZoneID)
            ->setShipVia($shipVia)
            ->setStatementCycleID($statementCycleID)
            ->setStatus($status)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setTerms($terms)
            ->setUnreleasedBalance($unreleasedBalance)
            ->setWarehouseID($warehouseID)
            ->setWriteOffLimit($writeOffLimit);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountRef
     * @return \StructType\Customer
     */
    public function setAccountRef(\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get ApplyOverdueCharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getApplyOverdueCharges()
    {
        return isset($this->ApplyOverdueCharges) ? $this->ApplyOverdueCharges : null;
    }
    /**
     * Set ApplyOverdueCharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $applyOverdueCharges
     * @return \StructType\Customer
     */
    public function setApplyOverdueCharges(\StructType\BooleanValue $applyOverdueCharges = null)
    {
        if (is_null($applyOverdueCharges) || (is_array($applyOverdueCharges) && empty($applyOverdueCharges))) {
            unset($this->ApplyOverdueCharges);
        } else {
            $this->ApplyOverdueCharges = $applyOverdueCharges;
        }
        return $this;
    }
    /**
     * Get AutoApplyPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAutoApplyPayments()
    {
        return isset($this->AutoApplyPayments) ? $this->AutoApplyPayments : null;
    }
    /**
     * Set AutoApplyPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $autoApplyPayments
     * @return \StructType\Customer
     */
    public function setAutoApplyPayments(\StructType\BooleanValue $autoApplyPayments = null)
    {
        if (is_null($autoApplyPayments) || (is_array($autoApplyPayments) && empty($autoApplyPayments))) {
            unset($this->AutoApplyPayments);
        } else {
            $this->AutoApplyPayments = $autoApplyPayments;
        }
        return $this;
    }
    /**
     * Get BillingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillingAddressSameAsMain()
    {
        return isset($this->BillingAddressSameAsMain) ? $this->BillingAddressSameAsMain : null;
    }
    /**
     * Set BillingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billingAddressSameAsMain
     * @return \StructType\Customer
     */
    public function setBillingAddressSameAsMain(\StructType\BooleanValue $billingAddressSameAsMain = null)
    {
        if (is_null($billingAddressSameAsMain) || (is_array($billingAddressSameAsMain) && empty($billingAddressSameAsMain))) {
            unset($this->BillingAddressSameAsMain);
        } else {
            $this->BillingAddressSameAsMain = $billingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get BillingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getBillingContact()
    {
        return isset($this->BillingContact) ? $this->BillingContact : null;
    }
    /**
     * Set BillingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $billingContact
     * @return \StructType\Customer
     */
    public function setBillingContact(\StructType\Contact $billingContact = null)
    {
        if (is_null($billingContact) || (is_array($billingContact) && empty($billingContact))) {
            unset($this->BillingContact);
        } else {
            $this->BillingContact = $billingContact;
        }
        return $this;
    }
    /**
     * Get BillingContactSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillingContactSameAsMain()
    {
        return isset($this->BillingContactSameAsMain) ? $this->BillingContactSameAsMain : null;
    }
    /**
     * Set BillingContactSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billingContactSameAsMain
     * @return \StructType\Customer
     */
    public function setBillingContactSameAsMain(\StructType\BooleanValue $billingContactSameAsMain = null)
    {
        if (is_null($billingContactSameAsMain) || (is_array($billingContactSameAsMain) && empty($billingContactSameAsMain))) {
            unset($this->BillingContactSameAsMain);
        } else {
            $this->BillingContactSameAsMain = $billingContactSameAsMain;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contacts $contacts
     * @return \StructType\Customer
     */
    public function setContacts(\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreditDaysPastDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getCreditDaysPastDue()
    {
        return isset($this->CreditDaysPastDue) ? $this->CreditDaysPastDue : null;
    }
    /**
     * Set CreditDaysPastDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $creditDaysPastDue
     * @return \StructType\Customer
     */
    public function setCreditDaysPastDue(\StructType\ShortValue $creditDaysPastDue = null)
    {
        if (is_null($creditDaysPastDue) || (is_array($creditDaysPastDue) && empty($creditDaysPastDue))) {
            unset($this->CreditDaysPastDue);
        } else {
            $this->CreditDaysPastDue = $creditDaysPastDue;
        }
        return $this;
    }
    /**
     * Get CreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCreditLimit()
    {
        return isset($this->CreditLimit) ? $this->CreditLimit : null;
    }
    /**
     * Set CreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $creditLimit
     * @return \StructType\Customer
     */
    public function setCreditLimit(\StructType\DecimalValue $creditLimit = null)
    {
        if (is_null($creditLimit) || (is_array($creditLimit) && empty($creditLimit))) {
            unset($this->CreditLimit);
        } else {
            $this->CreditLimit = $creditLimit;
        }
        return $this;
    }
    /**
     * Get CreditVerification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCreditVerification()
    {
        return isset($this->CreditVerification) ? $this->CreditVerification : null;
    }
    /**
     * Set CreditVerification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $creditVerification
     * @return \StructType\Customer
     */
    public function setCreditVerification(\StructType\StringValue $creditVerification = null)
    {
        if (is_null($creditVerification) || (is_array($creditVerification) && empty($creditVerification))) {
            unset($this->CreditVerification);
        } else {
            $this->CreditVerification = $creditVerification;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\Customer
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CustomerClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerClass()
    {
        return isset($this->CustomerClass) ? $this->CustomerClass : null;
    }
    /**
     * Set CustomerClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerClass
     * @return \StructType\Customer
     */
    public function setCustomerClass(\StructType\StringValue $customerClass = null)
    {
        if (is_null($customerClass) || (is_array($customerClass) && empty($customerClass))) {
            unset($this->CustomerClass);
        } else {
            $this->CustomerClass = $customerClass;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\Customer
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerName
     * @return \StructType\Customer
     */
    public function setCustomerName(\StructType\StringValue $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Get EnableWriteOffs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getEnableWriteOffs()
    {
        return isset($this->EnableWriteOffs) ? $this->EnableWriteOffs : null;
    }
    /**
     * Set EnableWriteOffs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $enableWriteOffs
     * @return \StructType\Customer
     */
    public function setEnableWriteOffs(\StructType\BooleanValue $enableWriteOffs = null)
    {
        if (is_null($enableWriteOffs) || (is_array($enableWriteOffs) && empty($enableWriteOffs))) {
            unset($this->EnableWriteOffs);
        } else {
            $this->EnableWriteOffs = $enableWriteOffs;
        }
        return $this;
    }
    /**
     * Get FirstInvoiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getFirstInvoiceDate()
    {
        return isset($this->FirstInvoiceDate) ? $this->FirstInvoiceDate : null;
    }
    /**
     * Set FirstInvoiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $firstInvoiceDate
     * @return \StructType\Customer
     */
    public function setFirstInvoiceDate(\StructType\DateTimeValue $firstInvoiceDate = null)
    {
        if (is_null($firstInvoiceDate) || (is_array($firstInvoiceDate) && empty($firstInvoiceDate))) {
            unset($this->FirstInvoiceDate);
        } else {
            $this->FirstInvoiceDate = $firstInvoiceDate;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $fOBPoint
     * @return \StructType\Customer
     */
    public function setFOBPoint(\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get LastModified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModified()
    {
        return isset($this->LastModified) ? $this->LastModified : null;
    }
    /**
     * Set LastModified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModified
     * @return \StructType\Customer
     */
    public function setLastModified(\StructType\DateTimeValue $lastModified = null)
    {
        if (is_null($lastModified) || (is_array($lastModified) && empty($lastModified))) {
            unset($this->LastModified);
        } else {
            $this->LastModified = $lastModified;
        }
        return $this;
    }
    /**
     * Get LeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getLeadTimedays()
    {
        return isset($this->LeadTimedays) ? $this->LeadTimedays : null;
    }
    /**
     * Set LeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $leadTimedays
     * @return \StructType\Customer
     */
    public function setLeadTimedays(\StructType\ShortValue $leadTimedays = null)
    {
        if (is_null($leadTimedays) || (is_array($leadTimedays) && empty($leadTimedays))) {
            unset($this->LeadTimedays);
        } else {
            $this->LeadTimedays = $leadTimedays;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationName
     * @return \StructType\Customer
     */
    public function setLocationName(\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $mainContact
     * @return \StructType\Customer
     */
    public function setMainContact(\StructType\Contact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get OpenOrdersBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOpenOrdersBalance()
    {
        return isset($this->OpenOrdersBalance) ? $this->OpenOrdersBalance : null;
    }
    /**
     * Set OpenOrdersBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $openOrdersBalance
     * @return \StructType\Customer
     */
    public function setOpenOrdersBalance(\StructType\DecimalValue $openOrdersBalance = null)
    {
        if (is_null($openOrdersBalance) || (is_array($openOrdersBalance) && empty($openOrdersBalance))) {
            unset($this->OpenOrdersBalance);
        } else {
            $this->OpenOrdersBalance = $openOrdersBalance;
        }
        return $this;
    }
    /**
     * Get OrderPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getOrderPriority()
    {
        return isset($this->OrderPriority) ? $this->OrderPriority : null;
    }
    /**
     * Set OrderPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $orderPriority
     * @return \StructType\Customer
     */
    public function setOrderPriority(\StructType\ShortValue $orderPriority = null)
    {
        if (is_null($orderPriority) || (is_array($orderPriority) && empty($orderPriority))) {
            unset($this->OrderPriority);
        } else {
            $this->OrderPriority = $orderPriority;
        }
        return $this;
    }
    /**
     * Get ParentRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getParentRecord()
    {
        return isset($this->ParentRecord) ? $this->ParentRecord : null;
    }
    /**
     * Set ParentRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $parentRecord
     * @return \StructType\Customer
     */
    public function setParentRecord(\StructType\StringValue $parentRecord = null)
    {
        if (is_null($parentRecord) || (is_array($parentRecord) && empty($parentRecord))) {
            unset($this->ParentRecord);
        } else {
            $this->ParentRecord = $parentRecord;
        }
        return $this;
    }
    /**
     * Get PriceClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPriceClassID()
    {
        return isset($this->PriceClassID) ? $this->PriceClassID : null;
    }
    /**
     * Set PriceClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $priceClassID
     * @return \StructType\Customer
     */
    public function setPriceClassID(\StructType\StringValue $priceClassID = null)
    {
        if (is_null($priceClassID) || (is_array($priceClassID) && empty($priceClassID))) {
            unset($this->PriceClassID);
        } else {
            $this->PriceClassID = $priceClassID;
        }
        return $this;
    }
    /**
     * Get PrintInvoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getPrintInvoices()
    {
        return isset($this->PrintInvoices) ? $this->PrintInvoices : null;
    }
    /**
     * Set PrintInvoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $printInvoices
     * @return \StructType\Customer
     */
    public function setPrintInvoices(\StructType\BooleanValue $printInvoices = null)
    {
        if (is_null($printInvoices) || (is_array($printInvoices) && empty($printInvoices))) {
            unset($this->PrintInvoices);
        } else {
            $this->PrintInvoices = $printInvoices;
        }
        return $this;
    }
    /**
     * Get PrintStatements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getPrintStatements()
    {
        return isset($this->PrintStatements) ? $this->PrintStatements : null;
    }
    /**
     * Set PrintStatements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $printStatements
     * @return \StructType\Customer
     */
    public function setPrintStatements(\StructType\BooleanValue $printStatements = null)
    {
        if (is_null($printStatements) || (is_array($printStatements) && empty($printStatements))) {
            unset($this->PrintStatements);
        } else {
            $this->PrintStatements = $printStatements;
        }
        return $this;
    }
    /**
     * Get RemainingCreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRemainingCreditLimit()
    {
        return isset($this->RemainingCreditLimit) ? $this->RemainingCreditLimit : null;
    }
    /**
     * Set RemainingCreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $remainingCreditLimit
     * @return \StructType\Customer
     */
    public function setRemainingCreditLimit(\StructType\DecimalValue $remainingCreditLimit = null)
    {
        if (is_null($remainingCreditLimit) || (is_array($remainingCreditLimit) && empty($remainingCreditLimit))) {
            unset($this->RemainingCreditLimit);
        } else {
            $this->RemainingCreditLimit = $remainingCreditLimit;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $residentialDelivery
     * @return \StructType\Customer
     */
    public function setResidentialDelivery(\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $saturdayDelivery
     * @return \StructType\Customer
     */
    public function setSaturdayDelivery(\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get SendInvoicesbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSendInvoicesbyEmail()
    {
        return isset($this->SendInvoicesbyEmail) ? $this->SendInvoicesbyEmail : null;
    }
    /**
     * Set SendInvoicesbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $sendInvoicesbyEmail
     * @return \StructType\Customer
     */
    public function setSendInvoicesbyEmail(\StructType\BooleanValue $sendInvoicesbyEmail = null)
    {
        if (is_null($sendInvoicesbyEmail) || (is_array($sendInvoicesbyEmail) && empty($sendInvoicesbyEmail))) {
            unset($this->SendInvoicesbyEmail);
        } else {
            $this->SendInvoicesbyEmail = $sendInvoicesbyEmail;
        }
        return $this;
    }
    /**
     * Get SendStatementsbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSendStatementsbyEmail()
    {
        return isset($this->SendStatementsbyEmail) ? $this->SendStatementsbyEmail : null;
    }
    /**
     * Set SendStatementsbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $sendStatementsbyEmail
     * @return \StructType\Customer
     */
    public function setSendStatementsbyEmail(\StructType\BooleanValue $sendStatementsbyEmail = null)
    {
        if (is_null($sendStatementsbyEmail) || (is_array($sendStatementsbyEmail) && empty($sendStatementsbyEmail))) {
            unset($this->SendStatementsbyEmail);
        } else {
            $this->SendStatementsbyEmail = $sendStatementsbyEmail;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShippingAddressSameAsMain()
    {
        return isset($this->ShippingAddressSameAsMain) ? $this->ShippingAddressSameAsMain : null;
    }
    /**
     * Set ShippingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shippingAddressSameAsMain
     * @return \StructType\Customer
     */
    public function setShippingAddressSameAsMain(\StructType\BooleanValue $shippingAddressSameAsMain = null)
    {
        if (is_null($shippingAddressSameAsMain) || (is_array($shippingAddressSameAsMain) && empty($shippingAddressSameAsMain))) {
            unset($this->ShippingAddressSameAsMain);
        } else {
            $this->ShippingAddressSameAsMain = $shippingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingBranch()
    {
        return isset($this->ShippingBranch) ? $this->ShippingBranch : null;
    }
    /**
     * Set ShippingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingBranch
     * @return \StructType\Customer
     */
    public function setShippingBranch(\StructType\StringValue $shippingBranch = null)
    {
        if (is_null($shippingBranch) || (is_array($shippingBranch) && empty($shippingBranch))) {
            unset($this->ShippingBranch);
        } else {
            $this->ShippingBranch = $shippingBranch;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $shippingContact
     * @return \StructType\Customer
     */
    public function setShippingContact(\StructType\Contact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get ShippingContactSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShippingContactSameAsMain()
    {
        return isset($this->ShippingContactSameAsMain) ? $this->ShippingContactSameAsMain : null;
    }
    /**
     * Set ShippingContactSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shippingContactSameAsMain
     * @return \StructType\Customer
     */
    public function setShippingContactSameAsMain(\StructType\BooleanValue $shippingContactSameAsMain = null)
    {
        if (is_null($shippingContactSameAsMain) || (is_array($shippingContactSameAsMain) && empty($shippingContactSameAsMain))) {
            unset($this->ShippingContactSameAsMain);
        } else {
            $this->ShippingContactSameAsMain = $shippingContactSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingRule
     * @return \StructType\Customer
     */
    public function setShippingRule(\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingTerms
     * @return \StructType\Customer
     */
    public function setShippingTerms(\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZoneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingZoneID()
    {
        return isset($this->ShippingZoneID) ? $this->ShippingZoneID : null;
    }
    /**
     * Set ShippingZoneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingZoneID
     * @return \StructType\Customer
     */
    public function setShippingZoneID(\StructType\StringValue $shippingZoneID = null)
    {
        if (is_null($shippingZoneID) || (is_array($shippingZoneID) && empty($shippingZoneID))) {
            unset($this->ShippingZoneID);
        } else {
            $this->ShippingZoneID = $shippingZoneID;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipVia
     * @return \StructType\Customer
     */
    public function setShipVia(\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get StatementCycleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatementCycleID()
    {
        return isset($this->StatementCycleID) ? $this->StatementCycleID : null;
    }
    /**
     * Set StatementCycleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $statementCycleID
     * @return \StructType\Customer
     */
    public function setStatementCycleID(\StructType\StringValue $statementCycleID = null)
    {
        if (is_null($statementCycleID) || (is_array($statementCycleID) && empty($statementCycleID))) {
            unset($this->StatementCycleID);
        } else {
            $this->StatementCycleID = $statementCycleID;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Customer
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxRegistrationID
     * @return \StructType\Customer
     */
    public function setTaxRegistrationID(\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxZone
     * @return \StructType\Customer
     */
    public function setTaxZone(\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $terms
     * @return \StructType\Customer
     */
    public function setTerms(\StructType\StringValue $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get UnreleasedBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnreleasedBalance()
    {
        return isset($this->UnreleasedBalance) ? $this->UnreleasedBalance : null;
    }
    /**
     * Set UnreleasedBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unreleasedBalance
     * @return \StructType\Customer
     */
    public function setUnreleasedBalance(\StructType\DecimalValue $unreleasedBalance = null)
    {
        if (is_null($unreleasedBalance) || (is_array($unreleasedBalance) && empty($unreleasedBalance))) {
            unset($this->UnreleasedBalance);
        } else {
            $this->UnreleasedBalance = $unreleasedBalance;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\Customer
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Get WriteOffLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getWriteOffLimit()
    {
        return isset($this->WriteOffLimit) ? $this->WriteOffLimit : null;
    }
    /**
     * Set WriteOffLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $writeOffLimit
     * @return \StructType\Customer
     */
    public function setWriteOffLimit(\StructType\DecimalValue $writeOffLimit = null)
    {
        if (is_null($writeOffLimit) || (is_array($writeOffLimit) && empty($writeOffLimit))) {
            unset($this->WriteOffLimit);
        } else {
            $this->WriteOffLimit = $writeOffLimit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
