<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomStringField StructType
 * @subpackage Structs
 */
class CustomStringField extends CustomField
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringValue
     */
    public $Value;
    /**
     * Constructor method for CustomStringField
     * @uses CustomStringField::setValue()
     * @param \StructType\StringValue $value
     */
    public function __construct(\StructType\StringValue $value = null)
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return \StructType\StringValue|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \StructType\StringValue $value
     * @return \StructType\CustomStringField
     */
    public function setValue(\StructType\StringValue $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomStringField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
