<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardProcessingDetail StructType
 * @subpackage Structs
 */
class CreditCardProcessingDetail extends Entity
{
    /**
     * The TranAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TranAmount;
    /**
     * The TranStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TranStatus;
    /**
     * Constructor method for CreditCardProcessingDetail
     * @uses CreditCardProcessingDetail::setTranAmount()
     * @uses CreditCardProcessingDetail::setTranStatus()
     * @param \StructType\DecimalValue $tranAmount
     * @param \StructType\StringValue $tranStatus
     */
    public function __construct(\StructType\DecimalValue $tranAmount = null, \StructType\StringValue $tranStatus = null)
    {
        $this
            ->setTranAmount($tranAmount)
            ->setTranStatus($tranStatus);
    }
    /**
     * Get TranAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTranAmount()
    {
        return isset($this->TranAmount) ? $this->TranAmount : null;
    }
    /**
     * Set TranAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $tranAmount
     * @return \StructType\CreditCardProcessingDetail
     */
    public function setTranAmount(\StructType\DecimalValue $tranAmount = null)
    {
        if (is_null($tranAmount) || (is_array($tranAmount) && empty($tranAmount))) {
            unset($this->TranAmount);
        } else {
            $this->TranAmount = $tranAmount;
        }
        return $this;
    }
    /**
     * Get TranStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTranStatus()
    {
        return isset($this->TranStatus) ? $this->TranStatus : null;
    }
    /**
     * Set TranStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $tranStatus
     * @return \StructType\CreditCardProcessingDetail
     */
    public function setTranStatus(\StructType\StringValue $tranStatus = null)
    {
        if (is_null($tranStatus) || (is_array($tranStatus) && empty($tranStatus))) {
            unset($this->TranStatus);
        } else {
            $this->TranStatus = $tranStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardProcessingDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
