<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attributes StructType
 * @subpackage Structs
 */
class Attributes extends AbstractStructBase
{
    /**
     * The AttributeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AttributeValue[]
     */
    public $AttributeValue;
    /**
     * The ItemClassAtrribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemClassAtrribute[]
     */
    public $ItemClassAtrribute;
    /**
     * Constructor method for Attributes
     * @uses Attributes::setAttributeValue()
     * @uses Attributes::setItemClassAtrribute()
     * @param \StructType\AttributeValue[] $attributeValue
     * @param \StructType\ItemClassAtrribute[] $itemClassAtrribute
     */
    public function __construct(array $attributeValue = array(), array $itemClassAtrribute = array())
    {
        $this
            ->setAttributeValue($attributeValue)
            ->setItemClassAtrribute($itemClassAtrribute);
    }
    /**
     * Get AttributeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AttributeValue[]|null
     */
    public function getAttributeValue()
    {
        return isset($this->AttributeValue) ? $this->AttributeValue : null;
    }
    /**
     * Set AttributeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeValue[] $attributeValue
     * @return \StructType\Attributes
     */
    public function setAttributeValue(array $attributeValue = array())
    {
        foreach ($attributeValue as $attributesAttributeValueItem) {
            // validation for constraint: itemType
            if (!$attributesAttributeValueItem instanceof \StructType\AttributeValue) {
                throw new \InvalidArgumentException(sprintf('The AttributeValue property can only contain items of \StructType\AttributeValue, "%s" given', is_object($attributesAttributeValueItem) ? get_class($attributesAttributeValueItem) : gettype($attributesAttributeValueItem)), __LINE__);
            }
        }
        if (is_null($attributeValue) || (is_array($attributeValue) && empty($attributeValue))) {
            unset($this->AttributeValue);
        } else {
            $this->AttributeValue = $attributeValue;
        }
        return $this;
    }
    /**
     * Add item to AttributeValue value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeValue $item
     * @return \StructType\Attributes
     */
    public function addToAttributeValue(\StructType\AttributeValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributeValue) {
            throw new \InvalidArgumentException(sprintf('The AttributeValue property can only contain items of \StructType\AttributeValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttributeValue[] = $item;
        return $this;
    }
    /**
     * Get ItemClassAtrribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemClassAtrribute[]|null
     */
    public function getItemClassAtrribute()
    {
        return isset($this->ItemClassAtrribute) ? $this->ItemClassAtrribute : null;
    }
    /**
     * Set ItemClassAtrribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemClassAtrribute[] $itemClassAtrribute
     * @return \StructType\Attributes
     */
    public function setItemClassAtrribute(array $itemClassAtrribute = array())
    {
        foreach ($itemClassAtrribute as $attributesItemClassAtrributeItem) {
            // validation for constraint: itemType
            if (!$attributesItemClassAtrributeItem instanceof \StructType\ItemClassAtrribute) {
                throw new \InvalidArgumentException(sprintf('The ItemClassAtrribute property can only contain items of \StructType\ItemClassAtrribute, "%s" given', is_object($attributesItemClassAtrributeItem) ? get_class($attributesItemClassAtrributeItem) : gettype($attributesItemClassAtrributeItem)), __LINE__);
            }
        }
        if (is_null($itemClassAtrribute) || (is_array($itemClassAtrribute) && empty($itemClassAtrribute))) {
            unset($this->ItemClassAtrribute);
        } else {
            $this->ItemClassAtrribute = $itemClassAtrribute;
        }
        return $this;
    }
    /**
     * Add item to ItemClassAtrribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemClassAtrribute $item
     * @return \StructType\Attributes
     */
    public function addToItemClassAtrribute(\StructType\ItemClassAtrribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemClassAtrribute) {
            throw new \InvalidArgumentException(sprintf('The ItemClassAtrribute property can only contain items of \StructType\ItemClassAtrribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemClassAtrribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
