<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeDefinitionValue StructType
 * @subpackage Structs
 */
class AttributeDefinitionValue extends Entity
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Disabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Disabled;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShortValue
     */
    public $SortOrder;
    /**
     * The ValueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ValueID;
    /**
     * Constructor method for AttributeDefinitionValue
     * @uses AttributeDefinitionValue::setDescription()
     * @uses AttributeDefinitionValue::setDisabled()
     * @uses AttributeDefinitionValue::setSortOrder()
     * @uses AttributeDefinitionValue::setValueID()
     * @param \StructType\StringValue $description
     * @param \StructType\BooleanValue $disabled
     * @param \StructType\ShortValue $sortOrder
     * @param \StructType\StringValue $valueID
     */
    public function __construct(\StructType\StringValue $description = null, \StructType\BooleanValue $disabled = null, \StructType\ShortValue $sortOrder = null, \StructType\StringValue $valueID = null)
    {
        $this
            ->setDescription($description)
            ->setDisabled($disabled)
            ->setSortOrder($sortOrder)
            ->setValueID($valueID);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\AttributeDefinitionValue
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Disabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getDisabled()
    {
        return isset($this->Disabled) ? $this->Disabled : null;
    }
    /**
     * Set Disabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $disabled
     * @return \StructType\AttributeDefinitionValue
     */
    public function setDisabled(\StructType\BooleanValue $disabled = null)
    {
        if (is_null($disabled) || (is_array($disabled) && empty($disabled))) {
            unset($this->Disabled);
        } else {
            $this->Disabled = $disabled;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShortValue|null
     */
    public function getSortOrder()
    {
        return isset($this->SortOrder) ? $this->SortOrder : null;
    }
    /**
     * Set SortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ShortValue $sortOrder
     * @return \StructType\AttributeDefinitionValue
     */
    public function setSortOrder(\StructType\ShortValue $sortOrder = null)
    {
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->SortOrder);
        } else {
            $this->SortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get ValueID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getValueID()
    {
        return isset($this->ValueID) ? $this->ValueID : null;
    }
    /**
     * Set ValueID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $valueID
     * @return \StructType\AttributeDefinitionValue
     */
    public function setValueID(\StructType\StringValue $valueID = null)
    {
        if (is_null($valueID) || (is_array($valueID) && empty($valueID))) {
            unset($this->ValueID);
        } else {
            $this->ValueID = $valueID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributeDefinitionValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
