<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warehouse StructType
 * @subpackage Structs
 */
class Warehouse extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DropShipLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DropShipLocationID;
    /**
     * The Locations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Locations
     */
    public $Locations;
    /**
     * The ReceivingLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReceivingLocationID;
    /**
     * The RMALocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RMALocationID;
    /**
     * The ShippingLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingLocationID;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for Warehouse
     * @uses Warehouse::setActive()
     * @uses Warehouse::setDescription()
     * @uses Warehouse::setDropShipLocationID()
     * @uses Warehouse::setLocations()
     * @uses Warehouse::setReceivingLocationID()
     * @uses Warehouse::setRMALocationID()
     * @uses Warehouse::setShippingLocationID()
     * @uses Warehouse::setWarehouseID()
     * @param \StructType\BooleanValue $active
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $dropShipLocationID
     * @param \StructType\Locations $locations
     * @param \StructType\StringValue $receivingLocationID
     * @param \StructType\StringValue $rMALocationID
     * @param \StructType\StringValue $shippingLocationID
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\StringValue $description = null, \StructType\StringValue $dropShipLocationID = null, \StructType\Locations $locations = null, \StructType\StringValue $receivingLocationID = null, \StructType\StringValue $rMALocationID = null, \StructType\StringValue $shippingLocationID = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setDropShipLocationID($dropShipLocationID)
            ->setLocations($locations)
            ->setReceivingLocationID($receivingLocationID)
            ->setRMALocationID($rMALocationID)
            ->setShippingLocationID($shippingLocationID)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\Warehouse
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Warehouse
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DropShipLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDropShipLocationID()
    {
        return isset($this->DropShipLocationID) ? $this->DropShipLocationID : null;
    }
    /**
     * Set DropShipLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $dropShipLocationID
     * @return \StructType\Warehouse
     */
    public function setDropShipLocationID(\StructType\StringValue $dropShipLocationID = null)
    {
        if (is_null($dropShipLocationID) || (is_array($dropShipLocationID) && empty($dropShipLocationID))) {
            unset($this->DropShipLocationID);
        } else {
            $this->DropShipLocationID = $dropShipLocationID;
        }
        return $this;
    }
    /**
     * Get Locations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Locations|null
     */
    public function getLocations()
    {
        return isset($this->Locations) ? $this->Locations : null;
    }
    /**
     * Set Locations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Locations $locations
     * @return \StructType\Warehouse
     */
    public function setLocations(\StructType\Locations $locations = null)
    {
        if (is_null($locations) || (is_array($locations) && empty($locations))) {
            unset($this->Locations);
        } else {
            $this->Locations = $locations;
        }
        return $this;
    }
    /**
     * Get ReceivingLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReceivingLocationID()
    {
        return isset($this->ReceivingLocationID) ? $this->ReceivingLocationID : null;
    }
    /**
     * Set ReceivingLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $receivingLocationID
     * @return \StructType\Warehouse
     */
    public function setReceivingLocationID(\StructType\StringValue $receivingLocationID = null)
    {
        if (is_null($receivingLocationID) || (is_array($receivingLocationID) && empty($receivingLocationID))) {
            unset($this->ReceivingLocationID);
        } else {
            $this->ReceivingLocationID = $receivingLocationID;
        }
        return $this;
    }
    /**
     * Get RMALocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRMALocationID()
    {
        return isset($this->RMALocationID) ? $this->RMALocationID : null;
    }
    /**
     * Set RMALocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $rMALocationID
     * @return \StructType\Warehouse
     */
    public function setRMALocationID(\StructType\StringValue $rMALocationID = null)
    {
        if (is_null($rMALocationID) || (is_array($rMALocationID) && empty($rMALocationID))) {
            unset($this->RMALocationID);
        } else {
            $this->RMALocationID = $rMALocationID;
        }
        return $this;
    }
    /**
     * Get ShippingLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingLocationID()
    {
        return isset($this->ShippingLocationID) ? $this->ShippingLocationID : null;
    }
    /**
     * Set ShippingLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingLocationID
     * @return \StructType\Warehouse
     */
    public function setShippingLocationID(\StructType\StringValue $shippingLocationID = null)
    {
        if (is_null($shippingLocationID) || (is_array($shippingLocationID) && empty($shippingLocationID))) {
            unset($this->ShippingLocationID);
        } else {
            $this->ShippingLocationID = $shippingLocationID;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\Warehouse
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Warehouse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
