<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipVia StructType
 * @subpackage Structs
 */
class ShipVia extends Entity
{
    /**
     * The CarrierID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CarrierID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Packages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Packages
     */
    public $Packages;
    /**
     * Constructor method for ShipVia
     * @uses ShipVia::setCarrierID()
     * @uses ShipVia::setDescription()
     * @uses ShipVia::setPackages()
     * @param \StructType\StringValue $carrierID
     * @param \StructType\StringValue $description
     * @param \StructType\Packages $packages
     */
    public function __construct(\StructType\StringValue $carrierID = null, \StructType\StringValue $description = null, \StructType\Packages $packages = null)
    {
        $this
            ->setCarrierID($carrierID)
            ->setDescription($description)
            ->setPackages($packages);
    }
    /**
     * Get CarrierID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCarrierID()
    {
        return isset($this->CarrierID) ? $this->CarrierID : null;
    }
    /**
     * Set CarrierID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $carrierID
     * @return \StructType\ShipVia
     */
    public function setCarrierID(\StructType\StringValue $carrierID = null)
    {
        if (is_null($carrierID) || (is_array($carrierID) && empty($carrierID))) {
            unset($this->CarrierID);
        } else {
            $this->CarrierID = $carrierID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ShipVia
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Packages|null
     */
    public function getPackages()
    {
        return isset($this->Packages) ? $this->Packages : null;
    }
    /**
     * Set Packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Packages $packages
     * @return \StructType\ShipVia
     */
    public function setPackages(\StructType\Packages $packages = null)
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->Packages);
        } else {
            $this->Packages = $packages;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipVia
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
