<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetBusinessDate StructType
 * @subpackage Structs
 */
class SetBusinessDate extends AbstractStructBase
{
    /**
     * The businessDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $businessDate;
    /**
     * Constructor method for SetBusinessDate
     * @uses SetBusinessDate::setBusinessDate()
     * @param string $businessDate
     */
    public function __construct($businessDate = null)
    {
        $this
            ->setBusinessDate($businessDate);
    }
    /**
     * Get businessDate value
     * @return string
     */
    public function getBusinessDate()
    {
        return $this->businessDate;
    }
    /**
     * Set businessDate value
     * @param string $businessDate
     * @return \StructType\SetBusinessDate
     */
    public function setBusinessDate($businessDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessDate) && !is_string($businessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessDate)), __LINE__);
        }
        $this->businessDate = $businessDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetBusinessDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
