<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderDetail StructType
 * @subpackage Structs
 */
class SalesOrderDetail extends Entity
{
    /**
     * The Allocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Allocations
     */
    public $Allocations;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LineDescription;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The ManualDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The OpenQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OpenQuantity;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Quantity;
    /**
     * The QuantityOnShipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $QuantityOnShipments;
    /**
     * The ShipOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ShipOn;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesOrderDetail
     * @uses SalesOrderDetail::setAllocations()
     * @uses SalesOrderDetail::setInventoryID()
     * @uses SalesOrderDetail::setLineDescription()
     * @uses SalesOrderDetail::setLineNbr()
     * @uses SalesOrderDetail::setManualDiscount()
     * @uses SalesOrderDetail::setOpenQuantity()
     * @uses SalesOrderDetail::setQuantity()
     * @uses SalesOrderDetail::setQuantityOnShipments()
     * @uses SalesOrderDetail::setShipOn()
     * @uses SalesOrderDetail::setUnitPrice()
     * @uses SalesOrderDetail::setUOM()
     * @uses SalesOrderDetail::setWarehouseID()
     * @param \StructType\Allocations $allocations
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\StringValue $lineDescription
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\BooleanValue $manualDiscount
     * @param \StructType\DecimalValue $openQuantity
     * @param \StructType\DecimalValue $quantity
     * @param \StructType\DecimalValue $quantityOnShipments
     * @param \StructType\DateTimeValue $shipOn
     * @param \StructType\DecimalValue $unitPrice
     * @param \StructType\StringValue $uOM
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\Allocations $allocations = null, \StructType\StringValue $inventoryID = null, \StructType\StringValue $lineDescription = null, \StructType\IntValue $lineNbr = null, \StructType\BooleanValue $manualDiscount = null, \StructType\DecimalValue $openQuantity = null, \StructType\DecimalValue $quantity = null, \StructType\DecimalValue $quantityOnShipments = null, \StructType\DateTimeValue $shipOn = null, \StructType\DecimalValue $unitPrice = null, \StructType\StringValue $uOM = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAllocations($allocations)
            ->setInventoryID($inventoryID)
            ->setLineDescription($lineDescription)
            ->setLineNbr($lineNbr)
            ->setManualDiscount($manualDiscount)
            ->setOpenQuantity($openQuantity)
            ->setQuantity($quantity)
            ->setQuantityOnShipments($quantityOnShipments)
            ->setShipOn($shipOn)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Allocations|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Allocations $allocations
     * @return \StructType\SalesOrderDetail
     */
    public function setAllocations(\StructType\Allocations $allocations = null)
    {
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\SalesOrderDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLineDescription()
    {
        return isset($this->LineDescription) ? $this->LineDescription : null;
    }
    /**
     * Set LineDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lineDescription
     * @return \StructType\SalesOrderDetail
     */
    public function setLineDescription(\StructType\StringValue $lineDescription = null)
    {
        if (is_null($lineDescription) || (is_array($lineDescription) && empty($lineDescription))) {
            unset($this->LineDescription);
        } else {
            $this->LineDescription = $lineDescription;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\SalesOrderDetail
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $manualDiscount
     * @return \StructType\SalesOrderDetail
     */
    public function setManualDiscount(\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get OpenQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOpenQuantity()
    {
        return isset($this->OpenQuantity) ? $this->OpenQuantity : null;
    }
    /**
     * Set OpenQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $openQuantity
     * @return \StructType\SalesOrderDetail
     */
    public function setOpenQuantity(\StructType\DecimalValue $openQuantity = null)
    {
        if (is_null($openQuantity) || (is_array($openQuantity) && empty($openQuantity))) {
            unset($this->OpenQuantity);
        } else {
            $this->OpenQuantity = $openQuantity;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $quantity
     * @return \StructType\SalesOrderDetail
     */
    public function setQuantity(\StructType\DecimalValue $quantity = null)
    {
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get QuantityOnShipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQuantityOnShipments()
    {
        return isset($this->QuantityOnShipments) ? $this->QuantityOnShipments : null;
    }
    /**
     * Set QuantityOnShipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $quantityOnShipments
     * @return \StructType\SalesOrderDetail
     */
    public function setQuantityOnShipments(\StructType\DecimalValue $quantityOnShipments = null)
    {
        if (is_null($quantityOnShipments) || (is_array($quantityOnShipments) && empty($quantityOnShipments))) {
            unset($this->QuantityOnShipments);
        } else {
            $this->QuantityOnShipments = $quantityOnShipments;
        }
        return $this;
    }
    /**
     * Get ShipOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getShipOn()
    {
        return isset($this->ShipOn) ? $this->ShipOn : null;
    }
    /**
     * Set ShipOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $shipOn
     * @return \StructType\SalesOrderDetail
     */
    public function setShipOn(\StructType\DateTimeValue $shipOn = null)
    {
        if (is_null($shipOn) || (is_array($shipOn) && empty($shipOn))) {
            unset($this->ShipOn);
        } else {
            $this->ShipOn = $shipOn;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitPrice
     * @return \StructType\SalesOrderDetail
     */
    public function setUnitPrice(\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\SalesOrderDetail
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\SalesOrderDetail
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesOrderDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
