<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrder StructType
 * @subpackage Structs
 */
class SalesOrder extends Entity
{
    /**
     * The BillingAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $BillingAddressOverride;
    /**
     * The BillingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $BillingContact;
    /**
     * The BillingContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $BillingContactOverride;
    /**
     * The CreditHold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CreditHold;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Currency;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DestinationWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DestinationWarehouseID;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The ExternalReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalReference;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The IsTaxValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IsTaxValid;
    /**
     * The LastModified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModified;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The NewCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $NewCard;
    /**
     * The OrderedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OrderedQty;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OrderTotal;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderType;
    /**
     * The PaymentCardIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentCardIdentifier;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The PreferredWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PreferredWarehouseID;
    /**
     * The Project
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Project;
    /**
     * The RequestedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $RequestedOn;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Shipments
     */
    public $Shipments;
    /**
     * The ShippingAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShippingAddressOverride;
    /**
     * The ShippingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $ShippingContact;
    /**
     * The ShippingContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShippingContactOverride;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * Constructor method for SalesOrder
     * @uses SalesOrder::setBillingAddressOverride()
     * @uses SalesOrder::setBillingContact()
     * @uses SalesOrder::setBillingContactOverride()
     * @uses SalesOrder::setCreditHold()
     * @uses SalesOrder::setCurrency()
     * @uses SalesOrder::setCustomerID()
     * @uses SalesOrder::setCustomerOrder()
     * @uses SalesOrder::setDate()
     * @uses SalesOrder::setDescription()
     * @uses SalesOrder::setDestinationWarehouseID()
     * @uses SalesOrder::setDetails()
     * @uses SalesOrder::setExternalReference()
     * @uses SalesOrder::setHold()
     * @uses SalesOrder::setIsTaxValid()
     * @uses SalesOrder::setLastModified()
     * @uses SalesOrder::setLocationID()
     * @uses SalesOrder::setNewCard()
     * @uses SalesOrder::setOrderedQty()
     * @uses SalesOrder::setOrderNbr()
     * @uses SalesOrder::setOrderTotal()
     * @uses SalesOrder::setOrderType()
     * @uses SalesOrder::setPaymentCardIdentifier()
     * @uses SalesOrder::setPaymentMethod()
     * @uses SalesOrder::setPaymentRef()
     * @uses SalesOrder::setPreferredWarehouseID()
     * @uses SalesOrder::setProject()
     * @uses SalesOrder::setRequestedOn()
     * @uses SalesOrder::setShipments()
     * @uses SalesOrder::setShippingAddressOverride()
     * @uses SalesOrder::setShippingContact()
     * @uses SalesOrder::setShippingContactOverride()
     * @uses SalesOrder::setShipVia()
     * @uses SalesOrder::setStatus()
     * @uses SalesOrder::setTaxTotal()
     * @param \StructType\BooleanValue $billingAddressOverride
     * @param \StructType\Contact $billingContact
     * @param \StructType\BooleanValue $billingContactOverride
     * @param \StructType\BooleanValue $creditHold
     * @param \StructType\StringValue $currency
     * @param \StructType\StringValue $customerID
     * @param \StructType\StringValue $customerOrder
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $destinationWarehouseID
     * @param \StructType\Details $details
     * @param \StructType\StringValue $externalReference
     * @param \StructType\BooleanValue $hold
     * @param \StructType\BooleanValue $isTaxValid
     * @param \StructType\DateTimeValue $lastModified
     * @param \StructType\StringValue $locationID
     * @param \StructType\BooleanValue $newCard
     * @param \StructType\DecimalValue $orderedQty
     * @param \StructType\StringValue $orderNbr
     * @param \StructType\DecimalValue $orderTotal
     * @param \StructType\StringValue $orderType
     * @param \StructType\StringValue $paymentCardIdentifier
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\StringValue $paymentRef
     * @param \StructType\StringValue $preferredWarehouseID
     * @param \StructType\StringValue $project
     * @param \StructType\DateTimeValue $requestedOn
     * @param \StructType\Shipments $shipments
     * @param \StructType\BooleanValue $shippingAddressOverride
     * @param \StructType\Contact $shippingContact
     * @param \StructType\BooleanValue $shippingContactOverride
     * @param \StructType\StringValue $shipVia
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $taxTotal
     */
    public function __construct(\StructType\BooleanValue $billingAddressOverride = null, \StructType\Contact $billingContact = null, \StructType\BooleanValue $billingContactOverride = null, \StructType\BooleanValue $creditHold = null, \StructType\StringValue $currency = null, \StructType\StringValue $customerID = null, \StructType\StringValue $customerOrder = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $description = null, \StructType\StringValue $destinationWarehouseID = null, \StructType\Details $details = null, \StructType\StringValue $externalReference = null, \StructType\BooleanValue $hold = null, \StructType\BooleanValue $isTaxValid = null, \StructType\DateTimeValue $lastModified = null, \StructType\StringValue $locationID = null, \StructType\BooleanValue $newCard = null, \StructType\DecimalValue $orderedQty = null, \StructType\StringValue $orderNbr = null, \StructType\DecimalValue $orderTotal = null, \StructType\StringValue $orderType = null, \StructType\StringValue $paymentCardIdentifier = null, \StructType\StringValue $paymentMethod = null, \StructType\StringValue $paymentRef = null, \StructType\StringValue $preferredWarehouseID = null, \StructType\StringValue $project = null, \StructType\DateTimeValue $requestedOn = null, \StructType\Shipments $shipments = null, \StructType\BooleanValue $shippingAddressOverride = null, \StructType\Contact $shippingContact = null, \StructType\BooleanValue $shippingContactOverride = null, \StructType\StringValue $shipVia = null, \StructType\StringValue $status = null, \StructType\DecimalValue $taxTotal = null)
    {
        $this
            ->setBillingAddressOverride($billingAddressOverride)
            ->setBillingContact($billingContact)
            ->setBillingContactOverride($billingContactOverride)
            ->setCreditHold($creditHold)
            ->setCurrency($currency)
            ->setCustomerID($customerID)
            ->setCustomerOrder($customerOrder)
            ->setDate($date)
            ->setDescription($description)
            ->setDestinationWarehouseID($destinationWarehouseID)
            ->setDetails($details)
            ->setExternalReference($externalReference)
            ->setHold($hold)
            ->setIsTaxValid($isTaxValid)
            ->setLastModified($lastModified)
            ->setLocationID($locationID)
            ->setNewCard($newCard)
            ->setOrderedQty($orderedQty)
            ->setOrderNbr($orderNbr)
            ->setOrderTotal($orderTotal)
            ->setOrderType($orderType)
            ->setPaymentCardIdentifier($paymentCardIdentifier)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setPreferredWarehouseID($preferredWarehouseID)
            ->setProject($project)
            ->setRequestedOn($requestedOn)
            ->setShipments($shipments)
            ->setShippingAddressOverride($shippingAddressOverride)
            ->setShippingContact($shippingContact)
            ->setShippingContactOverride($shippingContactOverride)
            ->setShipVia($shipVia)
            ->setStatus($status)
            ->setTaxTotal($taxTotal);
    }
    /**
     * Get BillingAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillingAddressOverride()
    {
        return isset($this->BillingAddressOverride) ? $this->BillingAddressOverride : null;
    }
    /**
     * Set BillingAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billingAddressOverride
     * @return \StructType\SalesOrder
     */
    public function setBillingAddressOverride(\StructType\BooleanValue $billingAddressOverride = null)
    {
        if (is_null($billingAddressOverride) || (is_array($billingAddressOverride) && empty($billingAddressOverride))) {
            unset($this->BillingAddressOverride);
        } else {
            $this->BillingAddressOverride = $billingAddressOverride;
        }
        return $this;
    }
    /**
     * Get BillingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getBillingContact()
    {
        return isset($this->BillingContact) ? $this->BillingContact : null;
    }
    /**
     * Set BillingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $billingContact
     * @return \StructType\SalesOrder
     */
    public function setBillingContact(\StructType\Contact $billingContact = null)
    {
        if (is_null($billingContact) || (is_array($billingContact) && empty($billingContact))) {
            unset($this->BillingContact);
        } else {
            $this->BillingContact = $billingContact;
        }
        return $this;
    }
    /**
     * Get BillingContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillingContactOverride()
    {
        return isset($this->BillingContactOverride) ? $this->BillingContactOverride : null;
    }
    /**
     * Set BillingContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billingContactOverride
     * @return \StructType\SalesOrder
     */
    public function setBillingContactOverride(\StructType\BooleanValue $billingContactOverride = null)
    {
        if (is_null($billingContactOverride) || (is_array($billingContactOverride) && empty($billingContactOverride))) {
            unset($this->BillingContactOverride);
        } else {
            $this->BillingContactOverride = $billingContactOverride;
        }
        return $this;
    }
    /**
     * Get CreditHold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCreditHold()
    {
        return isset($this->CreditHold) ? $this->CreditHold : null;
    }
    /**
     * Set CreditHold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $creditHold
     * @return \StructType\SalesOrder
     */
    public function setCreditHold(\StructType\BooleanValue $creditHold = null)
    {
        if (is_null($creditHold) || (is_array($creditHold) && empty($creditHold))) {
            unset($this->CreditHold);
        } else {
            $this->CreditHold = $creditHold;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currency
     * @return \StructType\SalesOrder
     */
    public function setCurrency(\StructType\StringValue $currency = null)
    {
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\SalesOrder
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerOrder
     * @return \StructType\SalesOrder
     */
    public function setCustomerOrder(\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\SalesOrder
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\SalesOrder
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DestinationWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDestinationWarehouseID()
    {
        return isset($this->DestinationWarehouseID) ? $this->DestinationWarehouseID : null;
    }
    /**
     * Set DestinationWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $destinationWarehouseID
     * @return \StructType\SalesOrder
     */
    public function setDestinationWarehouseID(\StructType\StringValue $destinationWarehouseID = null)
    {
        if (is_null($destinationWarehouseID) || (is_array($destinationWarehouseID) && empty($destinationWarehouseID))) {
            unset($this->DestinationWarehouseID);
        } else {
            $this->DestinationWarehouseID = $destinationWarehouseID;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\SalesOrder
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalReference
     * @return \StructType\SalesOrder
     */
    public function setExternalReference(\StructType\StringValue $externalReference = null)
    {
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\SalesOrder
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get IsTaxValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIsTaxValid()
    {
        return isset($this->IsTaxValid) ? $this->IsTaxValid : null;
    }
    /**
     * Set IsTaxValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $isTaxValid
     * @return \StructType\SalesOrder
     */
    public function setIsTaxValid(\StructType\BooleanValue $isTaxValid = null)
    {
        if (is_null($isTaxValid) || (is_array($isTaxValid) && empty($isTaxValid))) {
            unset($this->IsTaxValid);
        } else {
            $this->IsTaxValid = $isTaxValid;
        }
        return $this;
    }
    /**
     * Get LastModified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModified()
    {
        return isset($this->LastModified) ? $this->LastModified : null;
    }
    /**
     * Set LastModified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModified
     * @return \StructType\SalesOrder
     */
    public function setLastModified(\StructType\DateTimeValue $lastModified = null)
    {
        if (is_null($lastModified) || (is_array($lastModified) && empty($lastModified))) {
            unset($this->LastModified);
        } else {
            $this->LastModified = $lastModified;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\SalesOrder
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get NewCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getNewCard()
    {
        return isset($this->NewCard) ? $this->NewCard : null;
    }
    /**
     * Set NewCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $newCard
     * @return \StructType\SalesOrder
     */
    public function setNewCard(\StructType\BooleanValue $newCard = null)
    {
        if (is_null($newCard) || (is_array($newCard) && empty($newCard))) {
            unset($this->NewCard);
        } else {
            $this->NewCard = $newCard;
        }
        return $this;
    }
    /**
     * Get OrderedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOrderedQty()
    {
        return isset($this->OrderedQty) ? $this->OrderedQty : null;
    }
    /**
     * Set OrderedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $orderedQty
     * @return \StructType\SalesOrder
     */
    public function setOrderedQty(\StructType\DecimalValue $orderedQty = null)
    {
        if (is_null($orderedQty) || (is_array($orderedQty) && empty($orderedQty))) {
            unset($this->OrderedQty);
        } else {
            $this->OrderedQty = $orderedQty;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderNbr
     * @return \StructType\SalesOrder
     */
    public function setOrderNbr(\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOrderTotal()
    {
        return isset($this->OrderTotal) ? $this->OrderTotal : null;
    }
    /**
     * Set OrderTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $orderTotal
     * @return \StructType\SalesOrder
     */
    public function setOrderTotal(\StructType\DecimalValue $orderTotal = null)
    {
        if (is_null($orderTotal) || (is_array($orderTotal) && empty($orderTotal))) {
            unset($this->OrderTotal);
        } else {
            $this->OrderTotal = $orderTotal;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderType
     * @return \StructType\SalesOrder
     */
    public function setOrderType(\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PaymentCardIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentCardIdentifier()
    {
        return isset($this->PaymentCardIdentifier) ? $this->PaymentCardIdentifier : null;
    }
    /**
     * Set PaymentCardIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentCardIdentifier
     * @return \StructType\SalesOrder
     */
    public function setPaymentCardIdentifier(\StructType\StringValue $paymentCardIdentifier = null)
    {
        if (is_null($paymentCardIdentifier) || (is_array($paymentCardIdentifier) && empty($paymentCardIdentifier))) {
            unset($this->PaymentCardIdentifier);
        } else {
            $this->PaymentCardIdentifier = $paymentCardIdentifier;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\SalesOrder
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentRef
     * @return \StructType\SalesOrder
     */
    public function setPaymentRef(\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get PreferredWarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPreferredWarehouseID()
    {
        return isset($this->PreferredWarehouseID) ? $this->PreferredWarehouseID : null;
    }
    /**
     * Set PreferredWarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $preferredWarehouseID
     * @return \StructType\SalesOrder
     */
    public function setPreferredWarehouseID(\StructType\StringValue $preferredWarehouseID = null)
    {
        if (is_null($preferredWarehouseID) || (is_array($preferredWarehouseID) && empty($preferredWarehouseID))) {
            unset($this->PreferredWarehouseID);
        } else {
            $this->PreferredWarehouseID = $preferredWarehouseID;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $project
     * @return \StructType\SalesOrder
     */
    public function setProject(\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get RequestedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getRequestedOn()
    {
        return isset($this->RequestedOn) ? $this->RequestedOn : null;
    }
    /**
     * Set RequestedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $requestedOn
     * @return \StructType\SalesOrder
     */
    public function setRequestedOn(\StructType\DateTimeValue $requestedOn = null)
    {
        if (is_null($requestedOn) || (is_array($requestedOn) && empty($requestedOn))) {
            unset($this->RequestedOn);
        } else {
            $this->RequestedOn = $requestedOn;
        }
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Shipments|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Shipments $shipments
     * @return \StructType\SalesOrder
     */
    public function setShipments(\StructType\Shipments $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get ShippingAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShippingAddressOverride()
    {
        return isset($this->ShippingAddressOverride) ? $this->ShippingAddressOverride : null;
    }
    /**
     * Set ShippingAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shippingAddressOverride
     * @return \StructType\SalesOrder
     */
    public function setShippingAddressOverride(\StructType\BooleanValue $shippingAddressOverride = null)
    {
        if (is_null($shippingAddressOverride) || (is_array($shippingAddressOverride) && empty($shippingAddressOverride))) {
            unset($this->ShippingAddressOverride);
        } else {
            $this->ShippingAddressOverride = $shippingAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $shippingContact
     * @return \StructType\SalesOrder
     */
    public function setShippingContact(\StructType\Contact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get ShippingContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShippingContactOverride()
    {
        return isset($this->ShippingContactOverride) ? $this->ShippingContactOverride : null;
    }
    /**
     * Set ShippingContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shippingContactOverride
     * @return \StructType\SalesOrder
     */
    public function setShippingContactOverride(\StructType\BooleanValue $shippingContactOverride = null)
    {
        if (is_null($shippingContactOverride) || (is_array($shippingContactOverride) && empty($shippingContactOverride))) {
            unset($this->ShippingContactOverride);
        } else {
            $this->ShippingContactOverride = $shippingContactOverride;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipVia
     * @return \StructType\SalesOrder
     */
    public function setShipVia(\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\SalesOrder
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxTotal
     * @return \StructType\SalesOrder
     */
    public function setTaxTotal(\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
