<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Results StructType
 * @subpackage Structs
 */
class Results extends AbstractStructBase
{
    /**
     * The InventorySummaryRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InventorySummaryRow[]
     */
    public $InventorySummaryRow;
    /**
     * The CurrencyRateHistoryRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CurrencyRateHistoryRow[]
     */
    public $CurrencyRateHistoryRow;
    /**
     * Constructor method for Results
     * @uses Results::setInventorySummaryRow()
     * @uses Results::setCurrencyRateHistoryRow()
     * @param \StructType\InventorySummaryRow[] $inventorySummaryRow
     * @param \StructType\CurrencyRateHistoryRow[] $currencyRateHistoryRow
     */
    public function __construct(array $inventorySummaryRow = array(), array $currencyRateHistoryRow = array())
    {
        $this
            ->setInventorySummaryRow($inventorySummaryRow)
            ->setCurrencyRateHistoryRow($currencyRateHistoryRow);
    }
    /**
     * Get InventorySummaryRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InventorySummaryRow[]|null
     */
    public function getInventorySummaryRow()
    {
        return isset($this->InventorySummaryRow) ? $this->InventorySummaryRow : null;
    }
    /**
     * Set InventorySummaryRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InventorySummaryRow[] $inventorySummaryRow
     * @return \StructType\Results
     */
    public function setInventorySummaryRow(array $inventorySummaryRow = array())
    {
        foreach ($inventorySummaryRow as $resultsInventorySummaryRowItem) {
            // validation for constraint: itemType
            if (!$resultsInventorySummaryRowItem instanceof \StructType\InventorySummaryRow) {
                throw new \InvalidArgumentException(sprintf('The InventorySummaryRow property can only contain items of \StructType\InventorySummaryRow, "%s" given', is_object($resultsInventorySummaryRowItem) ? get_class($resultsInventorySummaryRowItem) : gettype($resultsInventorySummaryRowItem)), __LINE__);
            }
        }
        if (is_null($inventorySummaryRow) || (is_array($inventorySummaryRow) && empty($inventorySummaryRow))) {
            unset($this->InventorySummaryRow);
        } else {
            $this->InventorySummaryRow = $inventorySummaryRow;
        }
        return $this;
    }
    /**
     * Add item to InventorySummaryRow value
     * @throws \InvalidArgumentException
     * @param \StructType\InventorySummaryRow $item
     * @return \StructType\Results
     */
    public function addToInventorySummaryRow(\StructType\InventorySummaryRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventorySummaryRow) {
            throw new \InvalidArgumentException(sprintf('The InventorySummaryRow property can only contain items of \StructType\InventorySummaryRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventorySummaryRow[] = $item;
        return $this;
    }
    /**
     * Get CurrencyRateHistoryRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CurrencyRateHistoryRow[]|null
     */
    public function getCurrencyRateHistoryRow()
    {
        return isset($this->CurrencyRateHistoryRow) ? $this->CurrencyRateHistoryRow : null;
    }
    /**
     * Set CurrencyRateHistoryRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyRateHistoryRow[] $currencyRateHistoryRow
     * @return \StructType\Results
     */
    public function setCurrencyRateHistoryRow(array $currencyRateHistoryRow = array())
    {
        foreach ($currencyRateHistoryRow as $resultsCurrencyRateHistoryRowItem) {
            // validation for constraint: itemType
            if (!$resultsCurrencyRateHistoryRowItem instanceof \StructType\CurrencyRateHistoryRow) {
                throw new \InvalidArgumentException(sprintf('The CurrencyRateHistoryRow property can only contain items of \StructType\CurrencyRateHistoryRow, "%s" given', is_object($resultsCurrencyRateHistoryRowItem) ? get_class($resultsCurrencyRateHistoryRowItem) : gettype($resultsCurrencyRateHistoryRowItem)), __LINE__);
            }
        }
        if (is_null($currencyRateHistoryRow) || (is_array($currencyRateHistoryRow) && empty($currencyRateHistoryRow))) {
            unset($this->CurrencyRateHistoryRow);
        } else {
            $this->CurrencyRateHistoryRow = $currencyRateHistoryRow;
        }
        return $this;
    }
    /**
     * Add item to CurrencyRateHistoryRow value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyRateHistoryRow $item
     * @return \StructType\Results
     */
    public function addToCurrencyRateHistoryRow(\StructType\CurrencyRateHistoryRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyRateHistoryRow) {
            throw new \InvalidArgumentException(sprintf('The CurrencyRateHistoryRow property can only contain items of \StructType\CurrencyRateHistoryRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CurrencyRateHistoryRow[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Results
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
