<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentOrder StructType
 * @subpackage Structs
 */
class PaymentOrder extends Entity
{
    /**
     * The AppliedToOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AppliedToOrder;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderType;
    /**
     * Constructor method for PaymentOrder
     * @uses PaymentOrder::setAppliedToOrder()
     * @uses PaymentOrder::setOrderNbr()
     * @uses PaymentOrder::setOrderType()
     * @param \StructType\DecimalValue $appliedToOrder
     * @param \StructType\StringValue $orderNbr
     * @param \StructType\StringValue $orderType
     */
    public function __construct(\StructType\DecimalValue $appliedToOrder = null, \StructType\StringValue $orderNbr = null, \StructType\StringValue $orderType = null)
    {
        $this
            ->setAppliedToOrder($appliedToOrder)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType);
    }
    /**
     * Get AppliedToOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAppliedToOrder()
    {
        return isset($this->AppliedToOrder) ? $this->AppliedToOrder : null;
    }
    /**
     * Set AppliedToOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $appliedToOrder
     * @return \StructType\PaymentOrder
     */
    public function setAppliedToOrder(\StructType\DecimalValue $appliedToOrder = null)
    {
        if (is_null($appliedToOrder) || (is_array($appliedToOrder) && empty($appliedToOrder))) {
            unset($this->AppliedToOrder);
        } else {
            $this->AppliedToOrder = $appliedToOrder;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderNbr
     * @return \StructType\PaymentOrder
     */
    public function setOrderNbr(\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderType
     * @return \StructType\PaymentOrder
     */
    public function setOrderType(\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
