<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends Entity
{
    /**
     * The ApplicationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ApplicationDate;
    /**
     * The AppliedToDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AppliedToDocuments;
    /**
     * The CardAccountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $CardAccountNo;
    /**
     * The CashAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CreditCardProcessingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditCardProcessingInfo
     */
    public $CreditCardProcessingInfo;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DocumentsToApply
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentsToApply
     */
    public $DocumentsToApply;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The OrdersToApply
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrdersToApply
     */
    public $OrdersToApply;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for Payment
     * @uses Payment::setApplicationDate()
     * @uses Payment::setAppliedToDocuments()
     * @uses Payment::setCardAccountNo()
     * @uses Payment::setCashAccount()
     * @uses Payment::setCreditCardProcessingInfo()
     * @uses Payment::setCustomerID()
     * @uses Payment::setDescription()
     * @uses Payment::setDocumentsToApply()
     * @uses Payment::setHold()
     * @uses Payment::setOrdersToApply()
     * @uses Payment::setPaymentAmount()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setPaymentRef()
     * @uses Payment::setReferenceNbr()
     * @uses Payment::setStatus()
     * @uses Payment::setType()
     * @param \StructType\DateTimeValue $applicationDate
     * @param \StructType\DecimalValue $appliedToDocuments
     * @param \StructType\IntValue $cardAccountNo
     * @param \StructType\StringValue $cashAccount
     * @param \StructType\CreditCardProcessingInfo $creditCardProcessingInfo
     * @param \StructType\StringValue $customerID
     * @param \StructType\StringValue $description
     * @param \StructType\DocumentsToApply $documentsToApply
     * @param \StructType\BooleanValue $hold
     * @param \StructType\OrdersToApply $ordersToApply
     * @param \StructType\DecimalValue $paymentAmount
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\StringValue $paymentRef
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $type
     */
    public function __construct(\StructType\DateTimeValue $applicationDate = null, \StructType\DecimalValue $appliedToDocuments = null, \StructType\IntValue $cardAccountNo = null, \StructType\StringValue $cashAccount = null, \StructType\CreditCardProcessingInfo $creditCardProcessingInfo = null, \StructType\StringValue $customerID = null, \StructType\StringValue $description = null, \StructType\DocumentsToApply $documentsToApply = null, \StructType\BooleanValue $hold = null, \StructType\OrdersToApply $ordersToApply = null, \StructType\DecimalValue $paymentAmount = null, \StructType\StringValue $paymentMethod = null, \StructType\StringValue $paymentRef = null, \StructType\StringValue $referenceNbr = null, \StructType\StringValue $status = null, \StructType\StringValue $type = null)
    {
        $this
            ->setApplicationDate($applicationDate)
            ->setAppliedToDocuments($appliedToDocuments)
            ->setCardAccountNo($cardAccountNo)
            ->setCashAccount($cashAccount)
            ->setCreditCardProcessingInfo($creditCardProcessingInfo)
            ->setCustomerID($customerID)
            ->setDescription($description)
            ->setDocumentsToApply($documentsToApply)
            ->setHold($hold)
            ->setOrdersToApply($ordersToApply)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setType($type);
    }
    /**
     * Get ApplicationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getApplicationDate()
    {
        return isset($this->ApplicationDate) ? $this->ApplicationDate : null;
    }
    /**
     * Set ApplicationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $applicationDate
     * @return \StructType\Payment
     */
    public function setApplicationDate(\StructType\DateTimeValue $applicationDate = null)
    {
        if (is_null($applicationDate) || (is_array($applicationDate) && empty($applicationDate))) {
            unset($this->ApplicationDate);
        } else {
            $this->ApplicationDate = $applicationDate;
        }
        return $this;
    }
    /**
     * Get AppliedToDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAppliedToDocuments()
    {
        return isset($this->AppliedToDocuments) ? $this->AppliedToDocuments : null;
    }
    /**
     * Set AppliedToDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $appliedToDocuments
     * @return \StructType\Payment
     */
    public function setAppliedToDocuments(\StructType\DecimalValue $appliedToDocuments = null)
    {
        if (is_null($appliedToDocuments) || (is_array($appliedToDocuments) && empty($appliedToDocuments))) {
            unset($this->AppliedToDocuments);
        } else {
            $this->AppliedToDocuments = $appliedToDocuments;
        }
        return $this;
    }
    /**
     * Get CardAccountNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getCardAccountNo()
    {
        return isset($this->CardAccountNo) ? $this->CardAccountNo : null;
    }
    /**
     * Set CardAccountNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $cardAccountNo
     * @return \StructType\Payment
     */
    public function setCardAccountNo(\StructType\IntValue $cardAccountNo = null)
    {
        if (is_null($cardAccountNo) || (is_array($cardAccountNo) && empty($cardAccountNo))) {
            unset($this->CardAccountNo);
        } else {
            $this->CardAccountNo = $cardAccountNo;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cashAccount
     * @return \StructType\Payment
     */
    public function setCashAccount(\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CreditCardProcessingInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditCardProcessingInfo|null
     */
    public function getCreditCardProcessingInfo()
    {
        return isset($this->CreditCardProcessingInfo) ? $this->CreditCardProcessingInfo : null;
    }
    /**
     * Set CreditCardProcessingInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditCardProcessingInfo $creditCardProcessingInfo
     * @return \StructType\Payment
     */
    public function setCreditCardProcessingInfo(\StructType\CreditCardProcessingInfo $creditCardProcessingInfo = null)
    {
        if (is_null($creditCardProcessingInfo) || (is_array($creditCardProcessingInfo) && empty($creditCardProcessingInfo))) {
            unset($this->CreditCardProcessingInfo);
        } else {
            $this->CreditCardProcessingInfo = $creditCardProcessingInfo;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\Payment
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Payment
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DocumentsToApply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentsToApply|null
     */
    public function getDocumentsToApply()
    {
        return isset($this->DocumentsToApply) ? $this->DocumentsToApply : null;
    }
    /**
     * Set DocumentsToApply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentsToApply $documentsToApply
     * @return \StructType\Payment
     */
    public function setDocumentsToApply(\StructType\DocumentsToApply $documentsToApply = null)
    {
        if (is_null($documentsToApply) || (is_array($documentsToApply) && empty($documentsToApply))) {
            unset($this->DocumentsToApply);
        } else {
            $this->DocumentsToApply = $documentsToApply;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\Payment
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get OrdersToApply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrdersToApply|null
     */
    public function getOrdersToApply()
    {
        return isset($this->OrdersToApply) ? $this->OrdersToApply : null;
    }
    /**
     * Set OrdersToApply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrdersToApply $ordersToApply
     * @return \StructType\Payment
     */
    public function setOrdersToApply(\StructType\OrdersToApply $ordersToApply = null)
    {
        if (is_null($ordersToApply) || (is_array($ordersToApply) && empty($ordersToApply))) {
            unset($this->OrdersToApply);
        } else {
            $this->OrdersToApply = $ordersToApply;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPaymentAmount()
    {
        return isset($this->PaymentAmount) ? $this->PaymentAmount : null;
    }
    /**
     * Set PaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $paymentAmount
     * @return \StructType\Payment
     */
    public function setPaymentAmount(\StructType\DecimalValue $paymentAmount = null)
    {
        if (is_null($paymentAmount) || (is_array($paymentAmount) && empty($paymentAmount))) {
            unset($this->PaymentAmount);
        } else {
            $this->PaymentAmount = $paymentAmount;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\Payment
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentRef
     * @return \StructType\Payment
     */
    public function setPaymentRef(\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\Payment
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Payment
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\Payment
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
