<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonStockItem StructType
 * @subpackage Structs
 */
class NonStockItem extends Entity
{
    /**
     * The CrossReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CrossReferences
     */
    public $CrossReferences;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ItemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ItemType;
    /**
     * The RequireReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RequireReceipt;
    /**
     * The RequireShipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RequireShipment;
    /**
     * The VendorDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VendorDetails
     */
    public $VendorDetails;
    /**
     * Constructor method for NonStockItem
     * @uses NonStockItem::setCrossReferences()
     * @uses NonStockItem::setDescription()
     * @uses NonStockItem::setInventoryID()
     * @uses NonStockItem::setItemClass()
     * @uses NonStockItem::setItemType()
     * @uses NonStockItem::setRequireReceipt()
     * @uses NonStockItem::setRequireShipment()
     * @uses NonStockItem::setVendorDetails()
     * @param \StructType\CrossReferences $crossReferences
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\StringValue $itemClass
     * @param \StructType\StringValue $itemType
     * @param \StructType\BooleanValue $requireReceipt
     * @param \StructType\BooleanValue $requireShipment
     * @param \StructType\VendorDetails $vendorDetails
     */
    public function __construct(\StructType\CrossReferences $crossReferences = null, \StructType\StringValue $description = null, \StructType\StringValue $inventoryID = null, \StructType\StringValue $itemClass = null, \StructType\StringValue $itemType = null, \StructType\BooleanValue $requireReceipt = null, \StructType\BooleanValue $requireShipment = null, \StructType\VendorDetails $vendorDetails = null)
    {
        $this
            ->setCrossReferences($crossReferences)
            ->setDescription($description)
            ->setInventoryID($inventoryID)
            ->setItemClass($itemClass)
            ->setItemType($itemType)
            ->setRequireReceipt($requireReceipt)
            ->setRequireShipment($requireShipment)
            ->setVendorDetails($vendorDetails);
    }
    /**
     * Get CrossReferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CrossReferences|null
     */
    public function getCrossReferences()
    {
        return isset($this->CrossReferences) ? $this->CrossReferences : null;
    }
    /**
     * Set CrossReferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CrossReferences $crossReferences
     * @return \StructType\NonStockItem
     */
    public function setCrossReferences(\StructType\CrossReferences $crossReferences = null)
    {
        if (is_null($crossReferences) || (is_array($crossReferences) && empty($crossReferences))) {
            unset($this->CrossReferences);
        } else {
            $this->CrossReferences = $crossReferences;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\NonStockItem
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\NonStockItem
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $itemClass
     * @return \StructType\NonStockItem
     */
    public function setItemClass(\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $itemType
     * @return \StructType\NonStockItem
     */
    public function setItemType(\StructType\StringValue $itemType = null)
    {
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get RequireReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequireReceipt()
    {
        return isset($this->RequireReceipt) ? $this->RequireReceipt : null;
    }
    /**
     * Set RequireReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $requireReceipt
     * @return \StructType\NonStockItem
     */
    public function setRequireReceipt(\StructType\BooleanValue $requireReceipt = null)
    {
        if (is_null($requireReceipt) || (is_array($requireReceipt) && empty($requireReceipt))) {
            unset($this->RequireReceipt);
        } else {
            $this->RequireReceipt = $requireReceipt;
        }
        return $this;
    }
    /**
     * Get RequireShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequireShipment()
    {
        return isset($this->RequireShipment) ? $this->RequireShipment : null;
    }
    /**
     * Set RequireShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $requireShipment
     * @return \StructType\NonStockItem
     */
    public function setRequireShipment(\StructType\BooleanValue $requireShipment = null)
    {
        if (is_null($requireShipment) || (is_array($requireShipment) && empty($requireShipment))) {
            unset($this->RequireShipment);
        } else {
            $this->RequireShipment = $requireShipment;
        }
        return $this;
    }
    /**
     * Get VendorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VendorDetails|null
     */
    public function getVendorDetails()
    {
        return isset($this->VendorDetails) ? $this->VendorDetails : null;
    }
    /**
     * Set VendorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VendorDetails $vendorDetails
     * @return \StructType\NonStockItem
     */
    public function setVendorDetails(\StructType\VendorDetails $vendorDetails = null)
    {
        if (is_null($vendorDetails) || (is_array($vendorDetails) && empty($vendorDetails))) {
            unset($this->VendorDetails);
        } else {
            $this->VendorDetails = $vendorDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NonStockItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
