<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonStockComponents StructType
 * @subpackage Structs
 */
class NonStockComponents extends AbstractStructBase
{
    /**
     * The KitNonStockComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitNonStockComponent[]
     */
    public $KitNonStockComponent;
    /**
     * The KitAssemblyNonStockComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitAssemblyNonStockComponent[]
     */
    public $KitAssemblyNonStockComponent;
    /**
     * Constructor method for NonStockComponents
     * @uses NonStockComponents::setKitNonStockComponent()
     * @uses NonStockComponents::setKitAssemblyNonStockComponent()
     * @param \StructType\KitNonStockComponent[] $kitNonStockComponent
     * @param \StructType\KitAssemblyNonStockComponent[] $kitAssemblyNonStockComponent
     */
    public function __construct(array $kitNonStockComponent = array(), array $kitAssemblyNonStockComponent = array())
    {
        $this
            ->setKitNonStockComponent($kitNonStockComponent)
            ->setKitAssemblyNonStockComponent($kitAssemblyNonStockComponent);
    }
    /**
     * Get KitNonStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitNonStockComponent[]|null
     */
    public function getKitNonStockComponent()
    {
        return isset($this->KitNonStockComponent) ? $this->KitNonStockComponent : null;
    }
    /**
     * Set KitNonStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitNonStockComponent[] $kitNonStockComponent
     * @return \StructType\NonStockComponents
     */
    public function setKitNonStockComponent(array $kitNonStockComponent = array())
    {
        foreach ($kitNonStockComponent as $nonStockComponentsKitNonStockComponentItem) {
            // validation for constraint: itemType
            if (!$nonStockComponentsKitNonStockComponentItem instanceof \StructType\KitNonStockComponent) {
                throw new \InvalidArgumentException(sprintf('The KitNonStockComponent property can only contain items of \StructType\KitNonStockComponent, "%s" given', is_object($nonStockComponentsKitNonStockComponentItem) ? get_class($nonStockComponentsKitNonStockComponentItem) : gettype($nonStockComponentsKitNonStockComponentItem)), __LINE__);
            }
        }
        if (is_null($kitNonStockComponent) || (is_array($kitNonStockComponent) && empty($kitNonStockComponent))) {
            unset($this->KitNonStockComponent);
        } else {
            $this->KitNonStockComponent = $kitNonStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitNonStockComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\KitNonStockComponent $item
     * @return \StructType\NonStockComponents
     */
    public function addToKitNonStockComponent(\StructType\KitNonStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitNonStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitNonStockComponent property can only contain items of \StructType\KitNonStockComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitNonStockComponent[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyNonStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitAssemblyNonStockComponent[]|null
     */
    public function getKitAssemblyNonStockComponent()
    {
        return isset($this->KitAssemblyNonStockComponent) ? $this->KitAssemblyNonStockComponent : null;
    }
    /**
     * Set KitAssemblyNonStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitAssemblyNonStockComponent[] $kitAssemblyNonStockComponent
     * @return \StructType\NonStockComponents
     */
    public function setKitAssemblyNonStockComponent(array $kitAssemblyNonStockComponent = array())
    {
        foreach ($kitAssemblyNonStockComponent as $nonStockComponentsKitAssemblyNonStockComponentItem) {
            // validation for constraint: itemType
            if (!$nonStockComponentsKitAssemblyNonStockComponentItem instanceof \StructType\KitAssemblyNonStockComponent) {
                throw new \InvalidArgumentException(sprintf('The KitAssemblyNonStockComponent property can only contain items of \StructType\KitAssemblyNonStockComponent, "%s" given', is_object($nonStockComponentsKitAssemblyNonStockComponentItem) ? get_class($nonStockComponentsKitAssemblyNonStockComponentItem) : gettype($nonStockComponentsKitAssemblyNonStockComponentItem)), __LINE__);
            }
        }
        if (is_null($kitAssemblyNonStockComponent) || (is_array($kitAssemblyNonStockComponent) && empty($kitAssemblyNonStockComponent))) {
            unset($this->KitAssemblyNonStockComponent);
        } else {
            $this->KitAssemblyNonStockComponent = $kitAssemblyNonStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyNonStockComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\KitAssemblyNonStockComponent $item
     * @return \StructType\NonStockComponents
     */
    public function addToKitAssemblyNonStockComponent(\StructType\KitAssemblyNonStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitAssemblyNonStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyNonStockComponent property can only contain items of \StructType\KitAssemblyNonStockComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitAssemblyNonStockComponent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NonStockComponents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
