<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemCrossReference StructType
 * @subpackage Structs
 */
class InventoryItemCrossReference extends Entity
{
    /**
     * The AlternateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AlternateID;
    /**
     * The AlternateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AlternateType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The VendorCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorCustomer;
    /**
     * Constructor method for InventoryItemCrossReference
     * @uses InventoryItemCrossReference::setAlternateID()
     * @uses InventoryItemCrossReference::setAlternateType()
     * @uses InventoryItemCrossReference::setDescription()
     * @uses InventoryItemCrossReference::setVendorCustomer()
     * @param \StructType\StringValue $alternateID
     * @param \StructType\StringValue $alternateType
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $vendorCustomer
     */
    public function __construct(\StructType\StringValue $alternateID = null, \StructType\StringValue $alternateType = null, \StructType\StringValue $description = null, \StructType\StringValue $vendorCustomer = null)
    {
        $this
            ->setAlternateID($alternateID)
            ->setAlternateType($alternateType)
            ->setDescription($description)
            ->setVendorCustomer($vendorCustomer);
    }
    /**
     * Get AlternateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAlternateID()
    {
        return isset($this->AlternateID) ? $this->AlternateID : null;
    }
    /**
     * Set AlternateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $alternateID
     * @return \StructType\InventoryItemCrossReference
     */
    public function setAlternateID(\StructType\StringValue $alternateID = null)
    {
        if (is_null($alternateID) || (is_array($alternateID) && empty($alternateID))) {
            unset($this->AlternateID);
        } else {
            $this->AlternateID = $alternateID;
        }
        return $this;
    }
    /**
     * Get AlternateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAlternateType()
    {
        return isset($this->AlternateType) ? $this->AlternateType : null;
    }
    /**
     * Set AlternateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $alternateType
     * @return \StructType\InventoryItemCrossReference
     */
    public function setAlternateType(\StructType\StringValue $alternateType = null)
    {
        if (is_null($alternateType) || (is_array($alternateType) && empty($alternateType))) {
            unset($this->AlternateType);
        } else {
            $this->AlternateType = $alternateType;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\InventoryItemCrossReference
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get VendorCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorCustomer()
    {
        return isset($this->VendorCustomer) ? $this->VendorCustomer : null;
    }
    /**
     * Set VendorCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorCustomer
     * @return \StructType\InventoryItemCrossReference
     */
    public function setVendorCustomer(\StructType\StringValue $vendorCustomer = null)
    {
        if (is_null($vendorCustomer) || (is_array($vendorCustomer) && empty($vendorCustomer))) {
            unset($this->VendorCustomer);
        } else {
            $this->VendorCustomer = $vendorCustomer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryItemCrossReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
