<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employee StructType
 * @subpackage Structs
 */
class Employee extends Entity
{
    /**
     * The BranchID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BranchID;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $DateOfBirth;
    /**
     * The DepartmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DepartmentID;
    /**
     * The EmployeeClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EmployeeClassID;
    /**
     * The EmployeeCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmployeeCost
     */
    public $EmployeeCost;
    /**
     * The EmployeeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EmployeeID;
    /**
     * The EmploymentHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmploymentHistory
     */
    public $EmploymentHistory;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Name;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The ReportsToID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReportsToID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for Employee
     * @uses Employee::setBranchID()
     * @uses Employee::setContact()
     * @uses Employee::setCurrencyID()
     * @uses Employee::setDateOfBirth()
     * @uses Employee::setDepartmentID()
     * @uses Employee::setEmployeeClassID()
     * @uses Employee::setEmployeeCost()
     * @uses Employee::setEmployeeID()
     * @uses Employee::setEmploymentHistory()
     * @uses Employee::setName()
     * @uses Employee::setPaymentMethod()
     * @uses Employee::setReportsToID()
     * @uses Employee::setStatus()
     * @param \StructType\StringValue $branchID
     * @param \StructType\Contact $contact
     * @param \StructType\StringValue $currencyID
     * @param \StructType\DateTimeValue $dateOfBirth
     * @param \StructType\StringValue $departmentID
     * @param \StructType\StringValue $employeeClassID
     * @param \StructType\EmployeeCost $employeeCost
     * @param \StructType\StringValue $employeeID
     * @param \StructType\EmploymentHistory $employmentHistory
     * @param \StructType\StringValue $name
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\StringValue $reportsToID
     * @param \StructType\StringValue $status
     */
    public function __construct(\StructType\StringValue $branchID = null, \StructType\Contact $contact = null, \StructType\StringValue $currencyID = null, \StructType\DateTimeValue $dateOfBirth = null, \StructType\StringValue $departmentID = null, \StructType\StringValue $employeeClassID = null, \StructType\EmployeeCost $employeeCost = null, \StructType\StringValue $employeeID = null, \StructType\EmploymentHistory $employmentHistory = null, \StructType\StringValue $name = null, \StructType\StringValue $paymentMethod = null, \StructType\StringValue $reportsToID = null, \StructType\StringValue $status = null)
    {
        $this
            ->setBranchID($branchID)
            ->setContact($contact)
            ->setCurrencyID($currencyID)
            ->setDateOfBirth($dateOfBirth)
            ->setDepartmentID($departmentID)
            ->setEmployeeClassID($employeeClassID)
            ->setEmployeeCost($employeeCost)
            ->setEmployeeID($employeeID)
            ->setEmploymentHistory($employmentHistory)
            ->setName($name)
            ->setPaymentMethod($paymentMethod)
            ->setReportsToID($reportsToID)
            ->setStatus($status);
    }
    /**
     * Get BranchID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranchID()
    {
        return isset($this->BranchID) ? $this->BranchID : null;
    }
    /**
     * Set BranchID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branchID
     * @return \StructType\Employee
     */
    public function setBranchID(\StructType\StringValue $branchID = null)
    {
        if (is_null($branchID) || (is_array($branchID) && empty($branchID))) {
            unset($this->BranchID);
        } else {
            $this->BranchID = $branchID;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\Employee
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\Employee
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get DateOfBirth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDateOfBirth()
    {
        return isset($this->DateOfBirth) ? $this->DateOfBirth : null;
    }
    /**
     * Set DateOfBirth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $dateOfBirth
     * @return \StructType\Employee
     */
    public function setDateOfBirth(\StructType\DateTimeValue $dateOfBirth = null)
    {
        if (is_null($dateOfBirth) || (is_array($dateOfBirth) && empty($dateOfBirth))) {
            unset($this->DateOfBirth);
        } else {
            $this->DateOfBirth = $dateOfBirth;
        }
        return $this;
    }
    /**
     * Get DepartmentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDepartmentID()
    {
        return isset($this->DepartmentID) ? $this->DepartmentID : null;
    }
    /**
     * Set DepartmentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $departmentID
     * @return \StructType\Employee
     */
    public function setDepartmentID(\StructType\StringValue $departmentID = null)
    {
        if (is_null($departmentID) || (is_array($departmentID) && empty($departmentID))) {
            unset($this->DepartmentID);
        } else {
            $this->DepartmentID = $departmentID;
        }
        return $this;
    }
    /**
     * Get EmployeeClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployeeClassID()
    {
        return isset($this->EmployeeClassID) ? $this->EmployeeClassID : null;
    }
    /**
     * Set EmployeeClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employeeClassID
     * @return \StructType\Employee
     */
    public function setEmployeeClassID(\StructType\StringValue $employeeClassID = null)
    {
        if (is_null($employeeClassID) || (is_array($employeeClassID) && empty($employeeClassID))) {
            unset($this->EmployeeClassID);
        } else {
            $this->EmployeeClassID = $employeeClassID;
        }
        return $this;
    }
    /**
     * Get EmployeeCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmployeeCost|null
     */
    public function getEmployeeCost()
    {
        return isset($this->EmployeeCost) ? $this->EmployeeCost : null;
    }
    /**
     * Set EmployeeCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmployeeCost $employeeCost
     * @return \StructType\Employee
     */
    public function setEmployeeCost(\StructType\EmployeeCost $employeeCost = null)
    {
        if (is_null($employeeCost) || (is_array($employeeCost) && empty($employeeCost))) {
            unset($this->EmployeeCost);
        } else {
            $this->EmployeeCost = $employeeCost;
        }
        return $this;
    }
    /**
     * Get EmployeeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployeeID()
    {
        return isset($this->EmployeeID) ? $this->EmployeeID : null;
    }
    /**
     * Set EmployeeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employeeID
     * @return \StructType\Employee
     */
    public function setEmployeeID(\StructType\StringValue $employeeID = null)
    {
        if (is_null($employeeID) || (is_array($employeeID) && empty($employeeID))) {
            unset($this->EmployeeID);
        } else {
            $this->EmployeeID = $employeeID;
        }
        return $this;
    }
    /**
     * Get EmploymentHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmploymentHistory|null
     */
    public function getEmploymentHistory()
    {
        return isset($this->EmploymentHistory) ? $this->EmploymentHistory : null;
    }
    /**
     * Set EmploymentHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmploymentHistory $employmentHistory
     * @return \StructType\Employee
     */
    public function setEmploymentHistory(\StructType\EmploymentHistory $employmentHistory = null)
    {
        if (is_null($employmentHistory) || (is_array($employmentHistory) && empty($employmentHistory))) {
            unset($this->EmploymentHistory);
        } else {
            $this->EmploymentHistory = $employmentHistory;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $name
     * @return \StructType\Employee
     */
    public function setName(\StructType\StringValue $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\Employee
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get ReportsToID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReportsToID()
    {
        return isset($this->ReportsToID) ? $this->ReportsToID : null;
    }
    /**
     * Set ReportsToID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reportsToID
     * @return \StructType\Employee
     */
    public function setReportsToID(\StructType\StringValue $reportsToID = null)
    {
        if (is_null($reportsToID) || (is_array($reportsToID) && empty($reportsToID))) {
            unset($this->ReportsToID);
        } else {
            $this->ReportsToID = $reportsToID;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Employee
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Employee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
