<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentsToApply StructType
 * @subpackage Structs
 */
class DocumentsToApply extends AbstractStructBase
{
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentDetail[]
     */
    public $PaymentDetail;
    /**
     * Constructor method for DocumentsToApply
     * @uses DocumentsToApply::setPaymentDetail()
     * @param \StructType\PaymentDetail[] $paymentDetail
     */
    public function __construct(array $paymentDetail = array())
    {
        $this
            ->setPaymentDetail($paymentDetail);
    }
    /**
     * Get PaymentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentDetail[]|null
     */
    public function getPaymentDetail()
    {
        return isset($this->PaymentDetail) ? $this->PaymentDetail : null;
    }
    /**
     * Set PaymentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail[] $paymentDetail
     * @return \StructType\DocumentsToApply
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        foreach ($paymentDetail as $documentsToApplyPaymentDetailItem) {
            // validation for constraint: itemType
            if (!$documentsToApplyPaymentDetailItem instanceof \StructType\PaymentDetail) {
                throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of \StructType\PaymentDetail, "%s" given', is_object($documentsToApplyPaymentDetailItem) ? get_class($documentsToApplyPaymentDetailItem) : gettype($documentsToApplyPaymentDetailItem)), __LINE__);
            }
        }
        if (is_null($paymentDetail) || (is_array($paymentDetail) && empty($paymentDetail))) {
            unset($this->PaymentDetail);
        } else {
            $this->PaymentDetail = $paymentDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail $item
     * @return \StructType\DocumentsToApply
     */
    public function addToPaymentDetail(\StructType\PaymentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of \StructType\PaymentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentsToApply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
