<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Details StructType
 * @subpackage Structs
 */
class Details extends AbstractStructBase
{
    /**
     * The TransferOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransferOrderDetail[]
     */
    public $TransferOrderDetail;
    /**
     * The PurchaseOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PurchaseOrderDetail[]
     */
    public $PurchaseOrderDetail;
    /**
     * The SalesOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesOrderDetail[]
     */
    public $SalesOrderDetail;
    /**
     * The ShipmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipmentDetail[]
     */
    public $ShipmentDetail;
    /**
     * The CustomerPaymentMethodDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerPaymentMethodDetail[]
     */
    public $CustomerPaymentMethodDetail;
    /**
     * The JournalTransactionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JournalTransactionDetail[]
     */
    public $JournalTransactionDetail;
    /**
     * The PurchaseReceiptDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PurchaseReceiptDetail[]
     */
    public $PurchaseReceiptDetail;
    /**
     * The AdjustmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdjustmentDetail[]
     */
    public $AdjustmentDetail;
    /**
     * The PhysicalInventoryReviewDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PhysicalInventoryReviewDetail[]
     */
    public $PhysicalInventoryReviewDetail;
    /**
     * The SalesInvoiceDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesInvoiceDetail[]
     */
    public $SalesInvoiceDetail;
    /**
     * Constructor method for Details
     * @uses Details::setTransferOrderDetail()
     * @uses Details::setPurchaseOrderDetail()
     * @uses Details::setSalesOrderDetail()
     * @uses Details::setShipmentDetail()
     * @uses Details::setCustomerPaymentMethodDetail()
     * @uses Details::setJournalTransactionDetail()
     * @uses Details::setPurchaseReceiptDetail()
     * @uses Details::setAdjustmentDetail()
     * @uses Details::setPhysicalInventoryReviewDetail()
     * @uses Details::setSalesInvoiceDetail()
     * @param \StructType\TransferOrderDetail[] $transferOrderDetail
     * @param \StructType\PurchaseOrderDetail[] $purchaseOrderDetail
     * @param \StructType\SalesOrderDetail[] $salesOrderDetail
     * @param \StructType\ShipmentDetail[] $shipmentDetail
     * @param \StructType\CustomerPaymentMethodDetail[] $customerPaymentMethodDetail
     * @param \StructType\JournalTransactionDetail[] $journalTransactionDetail
     * @param \StructType\PurchaseReceiptDetail[] $purchaseReceiptDetail
     * @param \StructType\AdjustmentDetail[] $adjustmentDetail
     * @param \StructType\PhysicalInventoryReviewDetail[] $physicalInventoryReviewDetail
     * @param \StructType\SalesInvoiceDetail[] $salesInvoiceDetail
     */
    public function __construct(array $transferOrderDetail = array(), array $purchaseOrderDetail = array(), array $salesOrderDetail = array(), array $shipmentDetail = array(), array $customerPaymentMethodDetail = array(), array $journalTransactionDetail = array(), array $purchaseReceiptDetail = array(), array $adjustmentDetail = array(), array $physicalInventoryReviewDetail = array(), array $salesInvoiceDetail = array())
    {
        $this
            ->setTransferOrderDetail($transferOrderDetail)
            ->setPurchaseOrderDetail($purchaseOrderDetail)
            ->setSalesOrderDetail($salesOrderDetail)
            ->setShipmentDetail($shipmentDetail)
            ->setCustomerPaymentMethodDetail($customerPaymentMethodDetail)
            ->setJournalTransactionDetail($journalTransactionDetail)
            ->setPurchaseReceiptDetail($purchaseReceiptDetail)
            ->setAdjustmentDetail($adjustmentDetail)
            ->setPhysicalInventoryReviewDetail($physicalInventoryReviewDetail)
            ->setSalesInvoiceDetail($salesInvoiceDetail);
    }
    /**
     * Get TransferOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransferOrderDetail[]|null
     */
    public function getTransferOrderDetail()
    {
        return isset($this->TransferOrderDetail) ? $this->TransferOrderDetail : null;
    }
    /**
     * Set TransferOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransferOrderDetail[] $transferOrderDetail
     * @return \StructType\Details
     */
    public function setTransferOrderDetail(array $transferOrderDetail = array())
    {
        foreach ($transferOrderDetail as $detailsTransferOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsTransferOrderDetailItem instanceof \StructType\TransferOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The TransferOrderDetail property can only contain items of \StructType\TransferOrderDetail, "%s" given', is_object($detailsTransferOrderDetailItem) ? get_class($detailsTransferOrderDetailItem) : gettype($detailsTransferOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($transferOrderDetail) || (is_array($transferOrderDetail) && empty($transferOrderDetail))) {
            unset($this->TransferOrderDetail);
        } else {
            $this->TransferOrderDetail = $transferOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to TransferOrderDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TransferOrderDetail $item
     * @return \StructType\Details
     */
    public function addToTransferOrderDetail(\StructType\TransferOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransferOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The TransferOrderDetail property can only contain items of \StructType\TransferOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PurchaseOrderDetail[]|null
     */
    public function getPurchaseOrderDetail()
    {
        return isset($this->PurchaseOrderDetail) ? $this->PurchaseOrderDetail : null;
    }
    /**
     * Set PurchaseOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseOrderDetail[] $purchaseOrderDetail
     * @return \StructType\Details
     */
    public function setPurchaseOrderDetail(array $purchaseOrderDetail = array())
    {
        foreach ($purchaseOrderDetail as $detailsPurchaseOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPurchaseOrderDetailItem instanceof \StructType\PurchaseOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The PurchaseOrderDetail property can only contain items of \StructType\PurchaseOrderDetail, "%s" given', is_object($detailsPurchaseOrderDetailItem) ? get_class($detailsPurchaseOrderDetailItem) : gettype($detailsPurchaseOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($purchaseOrderDetail) || (is_array($purchaseOrderDetail) && empty($purchaseOrderDetail))) {
            unset($this->PurchaseOrderDetail);
        } else {
            $this->PurchaseOrderDetail = $purchaseOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseOrderDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseOrderDetail $item
     * @return \StructType\Details
     */
    public function addToPurchaseOrderDetail(\StructType\PurchaseOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchaseOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrderDetail property can only contain items of \StructType\PurchaseOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PurchaseOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesOrderDetail[]|null
     */
    public function getSalesOrderDetail()
    {
        return isset($this->SalesOrderDetail) ? $this->SalesOrderDetail : null;
    }
    /**
     * Set SalesOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesOrderDetail[] $salesOrderDetail
     * @return \StructType\Details
     */
    public function setSalesOrderDetail(array $salesOrderDetail = array())
    {
        foreach ($salesOrderDetail as $detailsSalesOrderDetailItem) {
            // validation for constraint: itemType
            if (!$detailsSalesOrderDetailItem instanceof \StructType\SalesOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The SalesOrderDetail property can only contain items of \StructType\SalesOrderDetail, "%s" given', is_object($detailsSalesOrderDetailItem) ? get_class($detailsSalesOrderDetailItem) : gettype($detailsSalesOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($salesOrderDetail) || (is_array($salesOrderDetail) && empty($salesOrderDetail))) {
            unset($this->SalesOrderDetail);
        } else {
            $this->SalesOrderDetail = $salesOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesOrderDetail $item
     * @return \StructType\Details
     */
    public function addToSalesOrderDetail(\StructType\SalesOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderDetail property can only contain items of \StructType\SalesOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesOrderDetail[] = $item;
        return $this;
    }
    /**
     * Get ShipmentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipmentDetail[]|null
     */
    public function getShipmentDetail()
    {
        return isset($this->ShipmentDetail) ? $this->ShipmentDetail : null;
    }
    /**
     * Set ShipmentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDetail[] $shipmentDetail
     * @return \StructType\Details
     */
    public function setShipmentDetail(array $shipmentDetail = array())
    {
        foreach ($shipmentDetail as $detailsShipmentDetailItem) {
            // validation for constraint: itemType
            if (!$detailsShipmentDetailItem instanceof \StructType\ShipmentDetail) {
                throw new \InvalidArgumentException(sprintf('The ShipmentDetail property can only contain items of \StructType\ShipmentDetail, "%s" given', is_object($detailsShipmentDetailItem) ? get_class($detailsShipmentDetailItem) : gettype($detailsShipmentDetailItem)), __LINE__);
            }
        }
        if (is_null($shipmentDetail) || (is_array($shipmentDetail) && empty($shipmentDetail))) {
            unset($this->ShipmentDetail);
        } else {
            $this->ShipmentDetail = $shipmentDetail;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDetail $item
     * @return \StructType\Details
     */
    public function addToShipmentDetail(\StructType\ShipmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentDetail) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDetail property can only contain items of \StructType\ShipmentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentDetail[] = $item;
        return $this;
    }
    /**
     * Get CustomerPaymentMethodDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerPaymentMethodDetail[]|null
     */
    public function getCustomerPaymentMethodDetail()
    {
        return isset($this->CustomerPaymentMethodDetail) ? $this->CustomerPaymentMethodDetail : null;
    }
    /**
     * Set CustomerPaymentMethodDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentMethodDetail[] $customerPaymentMethodDetail
     * @return \StructType\Details
     */
    public function setCustomerPaymentMethodDetail(array $customerPaymentMethodDetail = array())
    {
        foreach ($customerPaymentMethodDetail as $detailsCustomerPaymentMethodDetailItem) {
            // validation for constraint: itemType
            if (!$detailsCustomerPaymentMethodDetailItem instanceof \StructType\CustomerPaymentMethodDetail) {
                throw new \InvalidArgumentException(sprintf('The CustomerPaymentMethodDetail property can only contain items of \StructType\CustomerPaymentMethodDetail, "%s" given', is_object($detailsCustomerPaymentMethodDetailItem) ? get_class($detailsCustomerPaymentMethodDetailItem) : gettype($detailsCustomerPaymentMethodDetailItem)), __LINE__);
            }
        }
        if (is_null($customerPaymentMethodDetail) || (is_array($customerPaymentMethodDetail) && empty($customerPaymentMethodDetail))) {
            unset($this->CustomerPaymentMethodDetail);
        } else {
            $this->CustomerPaymentMethodDetail = $customerPaymentMethodDetail;
        }
        return $this;
    }
    /**
     * Add item to CustomerPaymentMethodDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentMethodDetail $item
     * @return \StructType\Details
     */
    public function addToCustomerPaymentMethodDetail(\StructType\CustomerPaymentMethodDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerPaymentMethodDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomerPaymentMethodDetail property can only contain items of \StructType\CustomerPaymentMethodDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerPaymentMethodDetail[] = $item;
        return $this;
    }
    /**
     * Get JournalTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JournalTransactionDetail[]|null
     */
    public function getJournalTransactionDetail()
    {
        return isset($this->JournalTransactionDetail) ? $this->JournalTransactionDetail : null;
    }
    /**
     * Set JournalTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JournalTransactionDetail[] $journalTransactionDetail
     * @return \StructType\Details
     */
    public function setJournalTransactionDetail(array $journalTransactionDetail = array())
    {
        foreach ($journalTransactionDetail as $detailsJournalTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$detailsJournalTransactionDetailItem instanceof \StructType\JournalTransactionDetail) {
                throw new \InvalidArgumentException(sprintf('The JournalTransactionDetail property can only contain items of \StructType\JournalTransactionDetail, "%s" given', is_object($detailsJournalTransactionDetailItem) ? get_class($detailsJournalTransactionDetailItem) : gettype($detailsJournalTransactionDetailItem)), __LINE__);
            }
        }
        if (is_null($journalTransactionDetail) || (is_array($journalTransactionDetail) && empty($journalTransactionDetail))) {
            unset($this->JournalTransactionDetail);
        } else {
            $this->JournalTransactionDetail = $journalTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to JournalTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\JournalTransactionDetail $item
     * @return \StructType\Details
     */
    public function addToJournalTransactionDetail(\StructType\JournalTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JournalTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The JournalTransactionDetail property can only contain items of \StructType\JournalTransactionDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JournalTransactionDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseReceiptDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PurchaseReceiptDetail[]|null
     */
    public function getPurchaseReceiptDetail()
    {
        return isset($this->PurchaseReceiptDetail) ? $this->PurchaseReceiptDetail : null;
    }
    /**
     * Set PurchaseReceiptDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseReceiptDetail[] $purchaseReceiptDetail
     * @return \StructType\Details
     */
    public function setPurchaseReceiptDetail(array $purchaseReceiptDetail = array())
    {
        foreach ($purchaseReceiptDetail as $detailsPurchaseReceiptDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPurchaseReceiptDetailItem instanceof \StructType\PurchaseReceiptDetail) {
                throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetail property can only contain items of \StructType\PurchaseReceiptDetail, "%s" given', is_object($detailsPurchaseReceiptDetailItem) ? get_class($detailsPurchaseReceiptDetailItem) : gettype($detailsPurchaseReceiptDetailItem)), __LINE__);
            }
        }
        if (is_null($purchaseReceiptDetail) || (is_array($purchaseReceiptDetail) && empty($purchaseReceiptDetail))) {
            unset($this->PurchaseReceiptDetail);
        } else {
            $this->PurchaseReceiptDetail = $purchaseReceiptDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseReceiptDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseReceiptDetail $item
     * @return \StructType\Details
     */
    public function addToPurchaseReceiptDetail(\StructType\PurchaseReceiptDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchaseReceiptDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetail property can only contain items of \StructType\PurchaseReceiptDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PurchaseReceiptDetail[] = $item;
        return $this;
    }
    /**
     * Get AdjustmentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdjustmentDetail[]|null
     */
    public function getAdjustmentDetail()
    {
        return isset($this->AdjustmentDetail) ? $this->AdjustmentDetail : null;
    }
    /**
     * Set AdjustmentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdjustmentDetail[] $adjustmentDetail
     * @return \StructType\Details
     */
    public function setAdjustmentDetail(array $adjustmentDetail = array())
    {
        foreach ($adjustmentDetail as $detailsAdjustmentDetailItem) {
            // validation for constraint: itemType
            if (!$detailsAdjustmentDetailItem instanceof \StructType\AdjustmentDetail) {
                throw new \InvalidArgumentException(sprintf('The AdjustmentDetail property can only contain items of \StructType\AdjustmentDetail, "%s" given', is_object($detailsAdjustmentDetailItem) ? get_class($detailsAdjustmentDetailItem) : gettype($detailsAdjustmentDetailItem)), __LINE__);
            }
        }
        if (is_null($adjustmentDetail) || (is_array($adjustmentDetail) && empty($adjustmentDetail))) {
            unset($this->AdjustmentDetail);
        } else {
            $this->AdjustmentDetail = $adjustmentDetail;
        }
        return $this;
    }
    /**
     * Add item to AdjustmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AdjustmentDetail $item
     * @return \StructType\Details
     */
    public function addToAdjustmentDetail(\StructType\AdjustmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdjustmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AdjustmentDetail property can only contain items of \StructType\AdjustmentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdjustmentDetail[] = $item;
        return $this;
    }
    /**
     * Get PhysicalInventoryReviewDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PhysicalInventoryReviewDetail[]|null
     */
    public function getPhysicalInventoryReviewDetail()
    {
        return isset($this->PhysicalInventoryReviewDetail) ? $this->PhysicalInventoryReviewDetail : null;
    }
    /**
     * Set PhysicalInventoryReviewDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PhysicalInventoryReviewDetail[] $physicalInventoryReviewDetail
     * @return \StructType\Details
     */
    public function setPhysicalInventoryReviewDetail(array $physicalInventoryReviewDetail = array())
    {
        foreach ($physicalInventoryReviewDetail as $detailsPhysicalInventoryReviewDetailItem) {
            // validation for constraint: itemType
            if (!$detailsPhysicalInventoryReviewDetailItem instanceof \StructType\PhysicalInventoryReviewDetail) {
                throw new \InvalidArgumentException(sprintf('The PhysicalInventoryReviewDetail property can only contain items of \StructType\PhysicalInventoryReviewDetail, "%s" given', is_object($detailsPhysicalInventoryReviewDetailItem) ? get_class($detailsPhysicalInventoryReviewDetailItem) : gettype($detailsPhysicalInventoryReviewDetailItem)), __LINE__);
            }
        }
        if (is_null($physicalInventoryReviewDetail) || (is_array($physicalInventoryReviewDetail) && empty($physicalInventoryReviewDetail))) {
            unset($this->PhysicalInventoryReviewDetail);
        } else {
            $this->PhysicalInventoryReviewDetail = $physicalInventoryReviewDetail;
        }
        return $this;
    }
    /**
     * Add item to PhysicalInventoryReviewDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysicalInventoryReviewDetail $item
     * @return \StructType\Details
     */
    public function addToPhysicalInventoryReviewDetail(\StructType\PhysicalInventoryReviewDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhysicalInventoryReviewDetail) {
            throw new \InvalidArgumentException(sprintf('The PhysicalInventoryReviewDetail property can only contain items of \StructType\PhysicalInventoryReviewDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysicalInventoryReviewDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesInvoiceDetail[]|null
     */
    public function getSalesInvoiceDetail()
    {
        return isset($this->SalesInvoiceDetail) ? $this->SalesInvoiceDetail : null;
    }
    /**
     * Set SalesInvoiceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceDetail[] $salesInvoiceDetail
     * @return \StructType\Details
     */
    public function setSalesInvoiceDetail(array $salesInvoiceDetail = array())
    {
        foreach ($salesInvoiceDetail as $detailsSalesInvoiceDetailItem) {
            // validation for constraint: itemType
            if (!$detailsSalesInvoiceDetailItem instanceof \StructType\SalesInvoiceDetail) {
                throw new \InvalidArgumentException(sprintf('The SalesInvoiceDetail property can only contain items of \StructType\SalesInvoiceDetail, "%s" given', is_object($detailsSalesInvoiceDetailItem) ? get_class($detailsSalesInvoiceDetailItem) : gettype($detailsSalesInvoiceDetailItem)), __LINE__);
            }
        }
        if (is_null($salesInvoiceDetail) || (is_array($salesInvoiceDetail) && empty($salesInvoiceDetail))) {
            unset($this->SalesInvoiceDetail);
        } else {
            $this->SalesInvoiceDetail = $salesInvoiceDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceDetail $item
     * @return \StructType\Details
     */
    public function addToSalesInvoiceDetail(\StructType\SalesInvoiceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesInvoiceDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceDetail property can only contain items of \StructType\SalesInvoiceDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesInvoiceDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Details
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
