<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contacts StructType
 * @subpackage Structs
 */
class Contacts extends AbstractStructBase
{
    /**
     * The CustomerContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerContact[]
     */
    public $CustomerContact;
    /**
     * Constructor method for Contacts
     * @uses Contacts::setCustomerContact()
     * @param \StructType\CustomerContact[] $customerContact
     */
    public function __construct(array $customerContact = array())
    {
        $this
            ->setCustomerContact($customerContact);
    }
    /**
     * Get CustomerContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerContact[]|null
     */
    public function getCustomerContact()
    {
        return isset($this->CustomerContact) ? $this->CustomerContact : null;
    }
    /**
     * Set CustomerContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerContact[] $customerContact
     * @return \StructType\Contacts
     */
    public function setCustomerContact(array $customerContact = array())
    {
        foreach ($customerContact as $contactsCustomerContactItem) {
            // validation for constraint: itemType
            if (!$contactsCustomerContactItem instanceof \StructType\CustomerContact) {
                throw new \InvalidArgumentException(sprintf('The CustomerContact property can only contain items of \StructType\CustomerContact, "%s" given', is_object($contactsCustomerContactItem) ? get_class($contactsCustomerContactItem) : gettype($contactsCustomerContactItem)), __LINE__);
            }
        }
        if (is_null($customerContact) || (is_array($customerContact) && empty($customerContact))) {
            unset($this->CustomerContact);
        } else {
            $this->CustomerContact = $customerContact;
        }
        return $this;
    }
    /**
     * Add item to CustomerContact value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerContact $item
     * @return \StructType\Contacts
     */
    public function addToCustomerContact(\StructType\CustomerContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerContact) {
            throw new \InvalidArgumentException(sprintf('The CustomerContact property can only contain items of \StructType\CustomerContact, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerContact[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contacts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
