<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeValue StructType
 * @subpackage Structs
 */
class AttributeValue extends Entity
{
    /**
     * The AttributeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AttributeID;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Value;
    /**
     * Constructor method for AttributeValue
     * @uses AttributeValue::setAttributeID()
     * @uses AttributeValue::setValue()
     * @param \StructType\StringValue $attributeID
     * @param \StructType\StringValue $value
     */
    public function __construct(\StructType\StringValue $attributeID = null, \StructType\StringValue $value = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setValue($value);
    }
    /**
     * Get AttributeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAttributeID()
    {
        return isset($this->AttributeID) ? $this->AttributeID : null;
    }
    /**
     * Set AttributeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $attributeID
     * @return \StructType\AttributeValue
     */
    public function setAttributeID(\StructType\StringValue $attributeID = null)
    {
        if (is_null($attributeID) || (is_array($attributeID) && empty($attributeID))) {
            unset($this->AttributeID);
        } else {
            $this->AttributeID = $attributeID;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $value
     * @return \StructType\AttributeValue
     */
    public function setValue(\StructType\StringValue $value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributeValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
