<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allocations StructType
 * @subpackage Structs
 */
class Allocations extends AbstractStructBase
{
    /**
     * The TransferOrderDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransferOrderDetailAllocation[]
     */
    public $TransferOrderDetailAllocation;
    /**
     * The SalesOrderDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesOrderDetailAllocation[]
     */
    public $SalesOrderDetailAllocation;
    /**
     * The ShipmentDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipmentDetailAllocation[]
     */
    public $ShipmentDetailAllocation;
    /**
     * The KitAssemblyAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitAssemblyAllocation[]
     */
    public $KitAssemblyAllocation;
    /**
     * Constructor method for Allocations
     * @uses Allocations::setTransferOrderDetailAllocation()
     * @uses Allocations::setSalesOrderDetailAllocation()
     * @uses Allocations::setShipmentDetailAllocation()
     * @uses Allocations::setKitAssemblyAllocation()
     * @param \StructType\TransferOrderDetailAllocation[] $transferOrderDetailAllocation
     * @param \StructType\SalesOrderDetailAllocation[] $salesOrderDetailAllocation
     * @param \StructType\ShipmentDetailAllocation[] $shipmentDetailAllocation
     * @param \StructType\KitAssemblyAllocation[] $kitAssemblyAllocation
     */
    public function __construct(array $transferOrderDetailAllocation = array(), array $salesOrderDetailAllocation = array(), array $shipmentDetailAllocation = array(), array $kitAssemblyAllocation = array())
    {
        $this
            ->setTransferOrderDetailAllocation($transferOrderDetailAllocation)
            ->setSalesOrderDetailAllocation($salesOrderDetailAllocation)
            ->setShipmentDetailAllocation($shipmentDetailAllocation)
            ->setKitAssemblyAllocation($kitAssemblyAllocation);
    }
    /**
     * Get TransferOrderDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransferOrderDetailAllocation[]|null
     */
    public function getTransferOrderDetailAllocation()
    {
        return isset($this->TransferOrderDetailAllocation) ? $this->TransferOrderDetailAllocation : null;
    }
    /**
     * Set TransferOrderDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransferOrderDetailAllocation[] $transferOrderDetailAllocation
     * @return \StructType\Allocations
     */
    public function setTransferOrderDetailAllocation(array $transferOrderDetailAllocation = array())
    {
        foreach ($transferOrderDetailAllocation as $allocationsTransferOrderDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsTransferOrderDetailAllocationItem instanceof \StructType\TransferOrderDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The TransferOrderDetailAllocation property can only contain items of \StructType\TransferOrderDetailAllocation, "%s" given', is_object($allocationsTransferOrderDetailAllocationItem) ? get_class($allocationsTransferOrderDetailAllocationItem) : gettype($allocationsTransferOrderDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($transferOrderDetailAllocation) || (is_array($transferOrderDetailAllocation) && empty($transferOrderDetailAllocation))) {
            unset($this->TransferOrderDetailAllocation);
        } else {
            $this->TransferOrderDetailAllocation = $transferOrderDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to TransferOrderDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \StructType\TransferOrderDetailAllocation $item
     * @return \StructType\Allocations
     */
    public function addToTransferOrderDetailAllocation(\StructType\TransferOrderDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransferOrderDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The TransferOrderDetailAllocation property can only contain items of \StructType\TransferOrderDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferOrderDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get SalesOrderDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesOrderDetailAllocation[]|null
     */
    public function getSalesOrderDetailAllocation()
    {
        return isset($this->SalesOrderDetailAllocation) ? $this->SalesOrderDetailAllocation : null;
    }
    /**
     * Set SalesOrderDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesOrderDetailAllocation[] $salesOrderDetailAllocation
     * @return \StructType\Allocations
     */
    public function setSalesOrderDetailAllocation(array $salesOrderDetailAllocation = array())
    {
        foreach ($salesOrderDetailAllocation as $allocationsSalesOrderDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsSalesOrderDetailAllocationItem instanceof \StructType\SalesOrderDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The SalesOrderDetailAllocation property can only contain items of \StructType\SalesOrderDetailAllocation, "%s" given', is_object($allocationsSalesOrderDetailAllocationItem) ? get_class($allocationsSalesOrderDetailAllocationItem) : gettype($allocationsSalesOrderDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($salesOrderDetailAllocation) || (is_array($salesOrderDetailAllocation) && empty($salesOrderDetailAllocation))) {
            unset($this->SalesOrderDetailAllocation);
        } else {
            $this->SalesOrderDetailAllocation = $salesOrderDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesOrderDetailAllocation $item
     * @return \StructType\Allocations
     */
    public function addToSalesOrderDetailAllocation(\StructType\SalesOrderDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesOrderDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderDetailAllocation property can only contain items of \StructType\SalesOrderDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesOrderDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get ShipmentDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipmentDetailAllocation[]|null
     */
    public function getShipmentDetailAllocation()
    {
        return isset($this->ShipmentDetailAllocation) ? $this->ShipmentDetailAllocation : null;
    }
    /**
     * Set ShipmentDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDetailAllocation[] $shipmentDetailAllocation
     * @return \StructType\Allocations
     */
    public function setShipmentDetailAllocation(array $shipmentDetailAllocation = array())
    {
        foreach ($shipmentDetailAllocation as $allocationsShipmentDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsShipmentDetailAllocationItem instanceof \StructType\ShipmentDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The ShipmentDetailAllocation property can only contain items of \StructType\ShipmentDetailAllocation, "%s" given', is_object($allocationsShipmentDetailAllocationItem) ? get_class($allocationsShipmentDetailAllocationItem) : gettype($allocationsShipmentDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($shipmentDetailAllocation) || (is_array($shipmentDetailAllocation) && empty($shipmentDetailAllocation))) {
            unset($this->ShipmentDetailAllocation);
        } else {
            $this->ShipmentDetailAllocation = $shipmentDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDetailAllocation $item
     * @return \StructType\Allocations
     */
    public function addToShipmentDetailAllocation(\StructType\ShipmentDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDetailAllocation property can only contain items of \StructType\ShipmentDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitAssemblyAllocation[]|null
     */
    public function getKitAssemblyAllocation()
    {
        return isset($this->KitAssemblyAllocation) ? $this->KitAssemblyAllocation : null;
    }
    /**
     * Set KitAssemblyAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitAssemblyAllocation[] $kitAssemblyAllocation
     * @return \StructType\Allocations
     */
    public function setKitAssemblyAllocation(array $kitAssemblyAllocation = array())
    {
        foreach ($kitAssemblyAllocation as $allocationsKitAssemblyAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsKitAssemblyAllocationItem instanceof \StructType\KitAssemblyAllocation) {
                throw new \InvalidArgumentException(sprintf('The KitAssemblyAllocation property can only contain items of \StructType\KitAssemblyAllocation, "%s" given', is_object($allocationsKitAssemblyAllocationItem) ? get_class($allocationsKitAssemblyAllocationItem) : gettype($allocationsKitAssemblyAllocationItem)), __LINE__);
            }
        }
        if (is_null($kitAssemblyAllocation) || (is_array($kitAssemblyAllocation) && empty($kitAssemblyAllocation))) {
            unset($this->KitAssemblyAllocation);
        } else {
            $this->KitAssemblyAllocation = $kitAssemblyAllocation;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyAllocation value
     * @throws \InvalidArgumentException
     * @param \StructType\KitAssemblyAllocation $item
     * @return \StructType\Allocations
     */
    public function addToKitAssemblyAllocation(\StructType\KitAssemblyAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitAssemblyAllocation) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyAllocation property can only contain items of \StructType\KitAssemblyAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitAssemblyAllocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Allocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
