<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVersionedDocumentResp ArrayType
 * @subpackage Arrays
 */
class ArrayOfVersionedDocumentResp extends AbstractStructArrayBase
{
    /**
     * The documents
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VersionedDocument[]
     */
    public $documents;
    /**
     * Constructor method for ArrayOfVersionedDocumentResp
     * @uses ArrayOfVersionedDocumentResp::setDocuments()
     * @param \StructType\VersionedDocument[] $documents
     */
    public function __construct(array $documents = array())
    {
        $this
            ->setDocuments($documents);
    }
    /**
     * Get documents value
     * @return \StructType\VersionedDocument[]|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @throws \InvalidArgumentException
     * @param \StructType\VersionedDocument[] $documents
     * @return \ArrayType\ArrayOfVersionedDocumentResp
     */
    public function setDocuments(array $documents = array())
    {
        foreach ($documents as $arrayOfVersionedDocumentRespDocumentsItem) {
            // validation for constraint: itemType
            if (!$arrayOfVersionedDocumentRespDocumentsItem instanceof \StructType\VersionedDocument) {
                throw new \InvalidArgumentException(sprintf('The documents property can only contain items of \StructType\VersionedDocument, "%s" given', is_object($arrayOfVersionedDocumentRespDocumentsItem) ? get_class($arrayOfVersionedDocumentRespDocumentsItem) : gettype($arrayOfVersionedDocumentRespDocumentsItem)), __LINE__);
            }
        }
        $this->documents = $documents;
        return $this;
    }
    /**
     * Add item to documents value
     * @throws \InvalidArgumentException
     * @param \StructType\VersionedDocument $item
     * @return \ArrayType\ArrayOfVersionedDocumentResp
     */
    public function addToDocuments(\StructType\VersionedDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VersionedDocument) {
            throw new \InvalidArgumentException(sprintf('The documents property can only contain items of \StructType\VersionedDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->documents[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VersionedDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VersionedDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VersionedDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VersionedDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VersionedDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string documents
     */
    public function getAttributeName()
    {
        return 'documents';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVersionedDocumentResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
