<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionedMessageReq StructType
 * @subpackage Structs
 */
class VersionedMessageReq extends AbstractStructBase
{
    /**
     * The dealId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dealId;
    /**
     * The documents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \ArrayType\ArrayOfVersionedDocumentReq
     */
    public $documents;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $messageId;
    /**
     * The receiver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $receiver;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sender;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $timestamp;
    /**
     * The transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $transaction;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $version;
    /**
     * Constructor method for VersionedMessageReq
     * @uses VersionedMessageReq::setDealId()
     * @uses VersionedMessageReq::setDocuments()
     * @uses VersionedMessageReq::setFormat()
     * @uses VersionedMessageReq::setMessageId()
     * @uses VersionedMessageReq::setReceiver()
     * @uses VersionedMessageReq::setSender()
     * @uses VersionedMessageReq::setTimestamp()
     * @uses VersionedMessageReq::setTransaction()
     * @uses VersionedMessageReq::setVersion()
     * @param string $dealId
     * @param \ArrayType\ArrayOfVersionedDocumentReq $documents
     * @param string $format
     * @param string $messageId
     * @param string $receiver
     * @param string $sender
     * @param string $timestamp
     * @param string $transaction
     * @param string $version
     */
    public function __construct($dealId = null, \ArrayType\ArrayOfVersionedDocumentReq $documents = null, $format = null, $messageId = null, $receiver = null, $sender = null, $timestamp = null, $transaction = null, $version = null)
    {
        $this
            ->setDealId($dealId)
            ->setDocuments($documents)
            ->setFormat($format)
            ->setMessageId($messageId)
            ->setReceiver($receiver)
            ->setSender($sender)
            ->setTimestamp($timestamp)
            ->setTransaction($transaction)
            ->setVersion($version);
    }
    /**
     * Get dealId value
     * @return string
     */
    public function getDealId()
    {
        return $this->dealId;
    }
    /**
     * Set dealId value
     * @param string $dealId
     * @return \StructType\VersionedMessageReq
     */
    public function setDealId($dealId = null)
    {
        // validation for constraint: string
        if (!is_null($dealId) && !is_string($dealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealId)), __LINE__);
        }
        $this->dealId = $dealId;
        return $this;
    }
    /**
     * Get documents value
     * @return \ArrayType\ArrayOfVersionedDocumentReq
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @param \ArrayType\ArrayOfVersionedDocumentReq $documents
     * @return \StructType\VersionedMessageReq
     */
    public function setDocuments(\ArrayType\ArrayOfVersionedDocumentReq $documents = null)
    {
        $this->documents = $documents;
        return $this;
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\VersionedMessageReq
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get messageId value
     * @return string
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param string $messageId
     * @return \StructType\VersionedMessageReq
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get receiver value
     * @return string
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param string $receiver
     * @return \StructType\VersionedMessageReq
     */
    public function setReceiver($receiver = null)
    {
        // validation for constraint: string
        if (!is_null($receiver) && !is_string($receiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiver)), __LINE__);
        }
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get sender value
     * @return string
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\VersionedMessageReq
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\VersionedMessageReq
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get transaction value
     * @return string
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param string $transaction
     * @return \StructType\VersionedMessageReq
     */
    public function setTransaction($transaction = null)
    {
        // validation for constraint: string
        if (!is_null($transaction) && !is_string($transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transaction)), __LINE__);
        }
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\VersionedMessageReq
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersionedMessageReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
