<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionedDocumentReq StructType
 * @subpackage Structs
 */
class VersionedDocumentReq extends AbstractStructBase
{
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $content;
    /**
     * The docname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $docname;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * The mimetype
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $mimetype;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $version;
    /**
     * Constructor method for VersionedDocumentReq
     * @uses VersionedDocumentReq::setContent()
     * @uses VersionedDocumentReq::setDocname()
     * @uses VersionedDocumentReq::setFormat()
     * @uses VersionedDocumentReq::setMimetype()
     * @uses VersionedDocumentReq::setVersion()
     * @param string $content
     * @param string $docname
     * @param string $format
     * @param string $mimetype
     * @param string $version
     */
    public function __construct($content = null, $docname = null, $format = null, $mimetype = null, $version = null)
    {
        $this
            ->setContent($content)
            ->setDocname($docname)
            ->setFormat($format)
            ->setMimetype($mimetype)
            ->setVersion($version);
    }
    /**
     * Get content value
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\VersionedDocumentReq
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get docname value
     * @return string
     */
    public function getDocname()
    {
        return $this->docname;
    }
    /**
     * Set docname value
     * @param string $docname
     * @return \StructType\VersionedDocumentReq
     */
    public function setDocname($docname = null)
    {
        // validation for constraint: string
        if (!is_null($docname) && !is_string($docname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docname)), __LINE__);
        }
        $this->docname = $docname;
        return $this;
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\VersionedDocumentReq
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get mimetype value
     * @return string
     */
    public function getMimetype()
    {
        return $this->mimetype;
    }
    /**
     * Set mimetype value
     * @param string $mimetype
     * @return \StructType\VersionedDocumentReq
     */
    public function setMimetype($mimetype = null)
    {
        // validation for constraint: string
        if (!is_null($mimetype) && !is_string($mimetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimetype)), __LINE__);
        }
        $this->mimetype = $mimetype;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\VersionedDocumentReq
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersionedDocumentReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
