<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessageRequest StructType
 * @subpackage Structs
 */
class GetMessageRequest extends AbstractStructBase
{
    /**
     * The channel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $channel;
    /**
     * The clientFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientFormat;
    /**
     * The clientVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientVersion;
    /**
     * Constructor method for GetMessageRequest
     * @uses GetMessageRequest::setChannel()
     * @uses GetMessageRequest::setClientFormat()
     * @uses GetMessageRequest::setClientVersion()
     * @param string $channel
     * @param string $clientFormat
     * @param string $clientVersion
     */
    public function __construct($channel = null, $clientFormat = null, $clientVersion = null)
    {
        $this
            ->setChannel($channel)
            ->setClientFormat($clientFormat)
            ->setClientVersion($clientVersion);
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return \StructType\GetMessageRequest
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get clientFormat value
     * @return string|null
     */
    public function getClientFormat()
    {
        return $this->clientFormat;
    }
    /**
     * Set clientFormat value
     * @param string $clientFormat
     * @return \StructType\GetMessageRequest
     */
    public function setClientFormat($clientFormat = null)
    {
        // validation for constraint: string
        if (!is_null($clientFormat) && !is_string($clientFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientFormat)), __LINE__);
        }
        $this->clientFormat = $clientFormat;
        return $this;
    }
    /**
     * Get clientVersion value
     * @return string|null
     */
    public function getClientVersion()
    {
        return $this->clientVersion;
    }
    /**
     * Set clientVersion value
     * @param string $clientVersion
     * @return \StructType\GetMessageRequest
     */
    public function setClientVersion($clientVersion = null)
    {
        // validation for constraint: string
        if (!is_null($clientVersion) && !is_string($clientVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientVersion)), __LINE__);
        }
        $this->clientVersion = $clientVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMessageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
