<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionedMessage StructType
 * @subpackage Structs
 */
class VersionedMessage extends AbstractStructBase
{
    /**
     * The dealId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dealId;
    /**
     * The documents
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfVersionedDocument
     */
    public $documents;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $messageId;
    /**
     * The receiver
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $receiver;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sender;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $timestamp;
    /**
     * The transaction
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $transaction;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $version;
    /**
     * Constructor method for VersionedMessage
     * @uses VersionedMessage::setDealId()
     * @uses VersionedMessage::setDocuments()
     * @uses VersionedMessage::setFormat()
     * @uses VersionedMessage::setMessageId()
     * @uses VersionedMessage::setReceiver()
     * @uses VersionedMessage::setSender()
     * @uses VersionedMessage::setTimestamp()
     * @uses VersionedMessage::setTransaction()
     * @uses VersionedMessage::setVersion()
     * @param string $dealId
     * @param \ArrayType\ArrayOfVersionedDocument $documents
     * @param string $format
     * @param string $messageId
     * @param string $receiver
     * @param string $sender
     * @param string $timestamp
     * @param string $transaction
     * @param string $version
     */
    public function __construct($dealId = null, \ArrayType\ArrayOfVersionedDocument $documents = null, $format = null, $messageId = null, $receiver = null, $sender = null, $timestamp = null, $transaction = null, $version = null)
    {
        $this
            ->setDealId($dealId)
            ->setDocuments($documents)
            ->setFormat($format)
            ->setMessageId($messageId)
            ->setReceiver($receiver)
            ->setSender($sender)
            ->setTimestamp($timestamp)
            ->setTransaction($transaction)
            ->setVersion($version);
    }
    /**
     * Get dealId value
     * @return string|null
     */
    public function getDealId()
    {
        return $this->dealId;
    }
    /**
     * Set dealId value
     * @param string $dealId
     * @return \StructType\VersionedMessage
     */
    public function setDealId($dealId = null)
    {
        // validation for constraint: string
        if (!is_null($dealId) && !is_string($dealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealId, true), gettype($dealId)), __LINE__);
        }
        $this->dealId = $dealId;
        return $this;
    }
    /**
     * Get documents value
     * @return \ArrayType\ArrayOfVersionedDocument|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @param \ArrayType\ArrayOfVersionedDocument $documents
     * @return \StructType\VersionedMessage
     */
    public function setDocuments(\ArrayType\ArrayOfVersionedDocument $documents = null)
    {
        $this->documents = $documents;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\VersionedMessage
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get messageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param string $messageId
     * @return \StructType\VersionedMessage
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get receiver value
     * @return string|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param string $receiver
     * @return \StructType\VersionedMessage
     */
    public function setReceiver($receiver = null)
    {
        // validation for constraint: string
        if (!is_null($receiver) && !is_string($receiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiver, true), gettype($receiver)), __LINE__);
        }
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\VersionedMessage
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\VersionedMessage
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get transaction value
     * @return string|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param string $transaction
     * @return \StructType\VersionedMessage
     */
    public function setTransaction($transaction = null)
    {
        // validation for constraint: string
        if (!is_null($transaction) && !is_string($transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction, true), gettype($transaction)), __LINE__);
        }
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\VersionedMessage
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersionedMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
