<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterCbuRequest StructType
 * @subpackage Structs
 */
class InterCbuRequest extends AbstractStructBase
{
    /**
     * The cbu
     * @var string
     */
    public $cbu;
    /**
     * The cuit
     * @var string
     */
    public $cuit;
    /**
     * Constructor method for InterCbuRequest
     * @uses InterCbuRequest::setCbu()
     * @uses InterCbuRequest::setCuit()
     * @param string $cbu
     * @param string $cuit
     */
    public function __construct($cbu = null, $cuit = null)
    {
        $this
            ->setCbu($cbu)
            ->setCuit($cuit);
    }
    /**
     * Get cbu value
     * @return string|null
     */
    public function getCbu()
    {
        return $this->cbu;
    }
    /**
     * Set cbu value
     * @param string $cbu
     * @return \StructType\InterCbuRequest
     */
    public function setCbu($cbu = null)
    {
        // validation for constraint: string
        if (!is_null($cbu) && !is_string($cbu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cbu)), __LINE__);
        }
        $this->cbu = $cbu;
        return $this;
    }
    /**
     * Get cuit value
     * @return string|null
     */
    public function getCuit()
    {
        return $this->cuit;
    }
    /**
     * Set cuit value
     * @param string $cuit
     * @return \StructType\InterCbuRequest
     */
    public function setCuit($cuit = null)
    {
        // validation for constraint: string
        if (!is_null($cuit) && !is_string($cuit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuit)), __LINE__);
        }
        $this->cuit = $cuit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InterCbuRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
