<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterCBUResponse StructType
 * @subpackage Structs
 */
class InterCBUResponse extends AbstractStructBase
{
    /**
     * The cbu
     * @var string
     */
    public $cbu;
    /**
     * The cuit
     * @var string
     */
    public $cuit;
    /**
     * The denominacion
     * @var string
     */
    public $denominacion;
    /**
     * The tipoRespuesta
     * @var string
     */
    public $tipoRespuesta;
    /**
     * The codigoRespuesta
     * @var string
     */
    public $codigoRespuesta;
    /**
     * Constructor method for InterCBUResponse
     * @uses InterCBUResponse::setCbu()
     * @uses InterCBUResponse::setCuit()
     * @uses InterCBUResponse::setDenominacion()
     * @uses InterCBUResponse::setTipoRespuesta()
     * @uses InterCBUResponse::setCodigoRespuesta()
     * @param string $cbu
     * @param string $cuit
     * @param string $denominacion
     * @param string $tipoRespuesta
     * @param string $codigoRespuesta
     */
    public function __construct($cbu = null, $cuit = null, $denominacion = null, $tipoRespuesta = null, $codigoRespuesta = null)
    {
        $this
            ->setCbu($cbu)
            ->setCuit($cuit)
            ->setDenominacion($denominacion)
            ->setTipoRespuesta($tipoRespuesta)
            ->setCodigoRespuesta($codigoRespuesta);
    }
    /**
     * Get cbu value
     * @return string|null
     */
    public function getCbu()
    {
        return $this->cbu;
    }
    /**
     * Set cbu value
     * @param string $cbu
     * @return \StructType\InterCBUResponse
     */
    public function setCbu($cbu = null)
    {
        // validation for constraint: string
        if (!is_null($cbu) && !is_string($cbu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cbu)), __LINE__);
        }
        $this->cbu = $cbu;
        return $this;
    }
    /**
     * Get cuit value
     * @return string|null
     */
    public function getCuit()
    {
        return $this->cuit;
    }
    /**
     * Set cuit value
     * @param string $cuit
     * @return \StructType\InterCBUResponse
     */
    public function setCuit($cuit = null)
    {
        // validation for constraint: string
        if (!is_null($cuit) && !is_string($cuit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cuit)), __LINE__);
        }
        $this->cuit = $cuit;
        return $this;
    }
    /**
     * Get denominacion value
     * @return string|null
     */
    public function getDenominacion()
    {
        return $this->denominacion;
    }
    /**
     * Set denominacion value
     * @param string $denominacion
     * @return \StructType\InterCBUResponse
     */
    public function setDenominacion($denominacion = null)
    {
        // validation for constraint: string
        if (!is_null($denominacion) && !is_string($denominacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($denominacion)), __LINE__);
        }
        $this->denominacion = $denominacion;
        return $this;
    }
    /**
     * Get tipoRespuesta value
     * @return string|null
     */
    public function getTipoRespuesta()
    {
        return $this->tipoRespuesta;
    }
    /**
     * Set tipoRespuesta value
     * @param string $tipoRespuesta
     * @return \StructType\InterCBUResponse
     */
    public function setTipoRespuesta($tipoRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRespuesta) && !is_string($tipoRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoRespuesta)), __LINE__);
        }
        $this->tipoRespuesta = $tipoRespuesta;
        return $this;
    }
    /**
     * Get codigoRespuesta value
     * @return string|null
     */
    public function getCodigoRespuesta()
    {
        return $this->codigoRespuesta;
    }
    /**
     * Set codigoRespuesta value
     * @param string $codigoRespuesta
     * @return \StructType\InterCBUResponse
     */
    public function setCodigoRespuesta($codigoRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRespuesta) && !is_string($codigoRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoRespuesta)), __LINE__);
        }
        $this->codigoRespuesta = $codigoRespuesta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InterCBUResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
