<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Air ServiceType
 * @subpackage Services
 */
class Air extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AirTimeTopUp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirTimeTopUp $parameters
     * @return \StructType\AirTimeTopUpResponse|bool
     */
    public function AirTimeTopUp(\StructType\AirTimeTopUp $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AirTimeTopUp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AirTimeTopUpResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
