<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopUp StructType
 * @subpackage Structs
 */
class TopUp extends AbstractStructBase
{
    /**
     * The sccode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sccode;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userid;
    /**
     * The bankcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bankcode;
    /**
     * The refno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $refno;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $date;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $amount;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * Constructor method for TopUp
     * @uses TopUp::setSccode()
     * @uses TopUp::setUserid()
     * @uses TopUp::setBankcode()
     * @uses TopUp::setRefno()
     * @uses TopUp::setDate()
     * @uses TopUp::setAmount()
     * @uses TopUp::setPassword()
     * @param string $sccode
     * @param string $userid
     * @param string $bankcode
     * @param string $refno
     * @param string $date
     * @param string $amount
     * @param string $password
     */
    public function __construct($sccode = null, $userid = null, $bankcode = null, $refno = null, $date = null, $amount = null, $password = null)
    {
        $this
            ->setSccode($sccode)
            ->setUserid($userid)
            ->setBankcode($bankcode)
            ->setRefno($refno)
            ->setDate($date)
            ->setAmount($amount)
            ->setPassword($password);
    }
    /**
     * Get sccode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSccode()
    {
        return isset($this->sccode) ? $this->sccode : null;
    }
    /**
     * Set sccode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sccode
     * @return \StructType\TopUp
     */
    public function setSccode($sccode = null)
    {
        // validation for constraint: string
        if (!is_null($sccode) && !is_string($sccode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sccode)), __LINE__);
        }
        if (is_null($sccode) || (is_array($sccode) && empty($sccode))) {
            unset($this->sccode);
        } else {
            $this->sccode = $sccode;
        }
        return $this;
    }
    /**
     * Get userid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserid()
    {
        return isset($this->userid) ? $this->userid : null;
    }
    /**
     * Set userid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userid
     * @return \StructType\TopUp
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        if (is_null($userid) || (is_array($userid) && empty($userid))) {
            unset($this->userid);
        } else {
            $this->userid = $userid;
        }
        return $this;
    }
    /**
     * Get bankcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankcode()
    {
        return isset($this->bankcode) ? $this->bankcode : null;
    }
    /**
     * Set bankcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankcode
     * @return \StructType\TopUp
     */
    public function setBankcode($bankcode = null)
    {
        // validation for constraint: string
        if (!is_null($bankcode) && !is_string($bankcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankcode)), __LINE__);
        }
        if (is_null($bankcode) || (is_array($bankcode) && empty($bankcode))) {
            unset($this->bankcode);
        } else {
            $this->bankcode = $bankcode;
        }
        return $this;
    }
    /**
     * Get refno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefno()
    {
        return isset($this->refno) ? $this->refno : null;
    }
    /**
     * Set refno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refno
     * @return \StructType\TopUp
     */
    public function setRefno($refno = null)
    {
        // validation for constraint: string
        if (!is_null($refno) && !is_string($refno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refno)), __LINE__);
        }
        if (is_null($refno) || (is_array($refno) && empty($refno))) {
            unset($this->refno);
        } else {
            $this->refno = $refno;
        }
        return $this;
    }
    /**
     * Get date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->date) ? $this->date : null;
    }
    /**
     * Set date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \StructType\TopUp
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->date);
        } else {
            $this->date = $date;
        }
        return $this;
    }
    /**
     * Get amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmount()
    {
        return isset($this->amount) ? $this->amount : null;
    }
    /**
     * Set amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amount
     * @return \StructType\TopUp
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->amount);
        } else {
            $this->amount = $amount;
        }
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\TopUp
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TopUp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
