<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDSTVProductResponse StructType
 * @subpackage Structs
 */
class GetDSTVProductResponse extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Product
     */
    public $product;
    /**
     * The respcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respcode;
    /**
     * The respmsg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respmsg;
    /**
     * Constructor method for GetDSTVProductResponse
     * @uses GetDSTVProductResponse::setProduct()
     * @uses GetDSTVProductResponse::setRespcode()
     * @uses GetDSTVProductResponse::setRespmsg()
     * @param \StructType\Product $product
     * @param string $respcode
     * @param string $respmsg
     */
    public function __construct(\StructType\Product $product = null, $respcode = null, $respmsg = null)
    {
        $this
            ->setProduct($product)
            ->setRespcode($respcode)
            ->setRespmsg($respmsg);
    }
    /**
     * Get product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Product|null
     */
    public function getProduct()
    {
        return isset($this->product) ? $this->product : null;
    }
    /**
     * Set product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Product $product
     * @return \StructType\GetDSTVProductResponse
     */
    public function setProduct(\StructType\Product $product = null)
    {
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->product);
        } else {
            $this->product = $product;
        }
        return $this;
    }
    /**
     * Get respcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespcode()
    {
        return isset($this->respcode) ? $this->respcode : null;
    }
    /**
     * Set respcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respcode
     * @return \StructType\GetDSTVProductResponse
     */
    public function setRespcode($respcode = null)
    {
        // validation for constraint: string
        if (!is_null($respcode) && !is_string($respcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respcode)), __LINE__);
        }
        if (is_null($respcode) || (is_array($respcode) && empty($respcode))) {
            unset($this->respcode);
        } else {
            $this->respcode = $respcode;
        }
        return $this;
    }
    /**
     * Get respmsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespmsg()
    {
        return isset($this->respmsg) ? $this->respmsg : null;
    }
    /**
     * Set respmsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respmsg
     * @return \StructType\GetDSTVProductResponse
     */
    public function setRespmsg($respmsg = null)
    {
        // validation for constraint: string
        if (!is_null($respmsg) && !is_string($respmsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respmsg)), __LINE__);
        }
        if (is_null($respmsg) || (is_array($respmsg) && empty($respmsg))) {
            unset($this->respmsg);
        } else {
            $this->respmsg = $respmsg;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDSTVProductResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
