<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://mmpuchong.mobile-money.com:1668/EMTerminalAPI/API.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://mmpuchong.mobile-money.com:1668/EMTerminalAPI/API.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Pay ServiceType
 */
$pay = new \ServiceType\Pay($options);
/**
 * Sample call for PayBill operation/method
 */
if ($pay->PayBill(new \StructType\PayBill()) !== false) {
    print_r($pay->getResult());
} else {
    print_r($pay->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateBillAccount operation/method
 */
if ($validate->ValidateBillAccount(new \StructType\ValidateBillAccount()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckBillStatus operation/method
 */
if ($check->CheckBillStatus(new \StructType\CheckBillStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckBalance operation/method
 */
if ($check->CheckBalance(new \StructType\CheckBalance()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetDSTVProduct operation/method
 */
if ($get->GetDSTVProduct(new \StructType\GetDSTVProduct()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDueAmountAndDate operation/method
 */
if ($get->GetDueAmountAndDate(new \StructType\GetDueAmountAndDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTelcoList operation/method
 */
if ($get->GetTelcoList(new \StructType\GetTelcoList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Top ServiceType
 */
$top = new \ServiceType\Top($options);
/**
 * Sample call for TopUp operation/method
 */
if ($top->TopUp(new \StructType\TopUp()) !== false) {
    print_r($top->getResult());
} else {
    print_r($top->getLastError());
}
/**
 * Samples for Air ServiceType
 */
$air = new \ServiceType\Air($options);
/**
 * Sample call for AirTimeTopUp operation/method
 */
if ($air->AirTimeTopUp(new \StructType\AirTimeTopUp()) !== false) {
    print_r($air->getResult());
} else {
    print_r($air->getLastError());
}
