<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDSTVProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDSTVProduct $parameters
     * @return \StructType\GetDSTVProductResponse|bool
     */
    public function GetDSTVProduct(\StructType\GetDSTVProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDSTVProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDueAmountAndDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDueAmountAndDate $parameters
     * @return \StructType\GetDueAmountAndDateResponse|bool
     */
    public function GetDueAmountAndDate(\StructType\GetDueAmountAndDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDueAmountAndDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTelcoList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTelcoList $parameters
     * @return \StructType\GetTelcoListResponse|bool
     */
    public function GetTelcoList(\StructType\GetTelcoList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTelcoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDSTVProductResponse|\StructType\GetDueAmountAndDateResponse|\StructType\GetTelcoListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
