<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retorno StructType
 * @subpackage Structs
 */
class Retorno extends AbstractStructBase
{
    /**
     * The CodigoRetorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CodigoRetorno;
    /**
     * The MensagemRetorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MensagemRetorno;
    /**
     * Constructor method for Retorno
     * @uses Retorno::setCodigoRetorno()
     * @uses Retorno::setMensagemRetorno()
     * @param int $codigoRetorno
     * @param string $mensagemRetorno
     */
    public function __construct($codigoRetorno = null, $mensagemRetorno = null)
    {
        $this
            ->setCodigoRetorno($codigoRetorno)
            ->setMensagemRetorno($mensagemRetorno);
    }
    /**
     * Get CodigoRetorno value
     * @return int
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param int $codigoRetorno
     * @return \StructType\Retorno
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: int
        if (!is_null($codigoRetorno) && !is_numeric($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
    /**
     * Get MensagemRetorno value
     * @return string
     */
    public function getMensagemRetorno()
    {
        return $this->MensagemRetorno;
    }
    /**
     * Set MensagemRetorno value
     * @param string $mensagemRetorno
     * @return \StructType\Retorno
     */
    public function setMensagemRetorno($mensagemRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($mensagemRetorno) && !is_string($mensagemRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mensagemRetorno)), __LINE__);
        }
        $this->MensagemRetorno = $mensagemRetorno;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Retorno
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
