<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemCDIRetorno StructType
 * @subpackage Structs
 */
class ItemCDIRetorno extends AbstractStructBase
{
    /**
     * The CnpjCpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CnpjCpf;
    /**
     * The UrlDocumento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UrlDocumento;
    /**
     * Constructor method for ItemCDIRetorno
     * @uses ItemCDIRetorno::setCnpjCpf()
     * @uses ItemCDIRetorno::setUrlDocumento()
     * @param string $cnpjCpf
     * @param string $urlDocumento
     */
    public function __construct($cnpjCpf = null, $urlDocumento = null)
    {
        $this
            ->setCnpjCpf($cnpjCpf)
            ->setUrlDocumento($urlDocumento);
    }
    /**
     * Get CnpjCpf value
     * @return string
     */
    public function getCnpjCpf()
    {
        return $this->CnpjCpf;
    }
    /**
     * Set CnpjCpf value
     * @param string $cnpjCpf
     * @return \StructType\ItemCDIRetorno
     */
    public function setCnpjCpf($cnpjCpf = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjCpf) && !is_string($cnpjCpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cnpjCpf)), __LINE__);
        }
        $this->CnpjCpf = $cnpjCpf;
        return $this;
    }
    /**
     * Get UrlDocumento value
     * @return string
     */
    public function getUrlDocumento()
    {
        return $this->UrlDocumento;
    }
    /**
     * Set UrlDocumento value
     * @param string $urlDocumento
     * @return \StructType\ItemCDIRetorno
     */
    public function setUrlDocumento($urlDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($urlDocumento) && !is_string($urlDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlDocumento)), __LINE__);
        }
        $this->UrlDocumento = $urlDocumento;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemCDIRetorno
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
