<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Emitente StructType
 * @subpackage Structs
 */
class Emitente extends AbstractStructBase
{
    /**
     * The CnpjEmitente
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CnpjEmitente;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * Constructor method for Emitente
     * @uses Emitente::setCnpjEmitente()
     * @uses Emitente::setEmail()
     * @param int $cnpjEmitente
     * @param string $email
     */
    public function __construct($cnpjEmitente = null, $email = null)
    {
        $this
            ->setCnpjEmitente($cnpjEmitente)
            ->setEmail($email);
    }
    /**
     * Get CnpjEmitente value
     * @return int
     */
    public function getCnpjEmitente()
    {
        return $this->CnpjEmitente;
    }
    /**
     * Set CnpjEmitente value
     * @param int $cnpjEmitente
     * @return \StructType\Emitente
     */
    public function setCnpjEmitente($cnpjEmitente = null)
    {
        // validation for constraint: int
        if (!is_null($cnpjEmitente) && !is_numeric($cnpjEmitente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cnpjEmitente)), __LINE__);
        }
        $this->CnpjEmitente = $cnpjEmitente;
        return $this;
    }
    /**
     * Get Email value
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Emitente
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Emitente
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
