<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoITD StructType
 * @subpackage Structs
 */
class DocumentoITD extends AbstractStructBase
{
    /**
     * The CnpjCpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CnpjCpf;
    /**
     * The DataPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The NumGuiaControle
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NumGuiaControle;
    /**
     * Constructor method for DocumentoITD
     * @uses DocumentoITD::setCnpjCpf()
     * @uses DocumentoITD::setDataPagamento()
     * @uses DocumentoITD::setNumGuiaControle()
     * @param string $cnpjCpf
     * @param string $dataPagamento
     * @param string $numGuiaControle
     */
    public function __construct($cnpjCpf = null, $dataPagamento = null, $numGuiaControle = null)
    {
        $this
            ->setCnpjCpf($cnpjCpf)
            ->setDataPagamento($dataPagamento)
            ->setNumGuiaControle($numGuiaControle);
    }
    /**
     * Get CnpjCpf value
     * @return string
     */
    public function getCnpjCpf()
    {
        return $this->CnpjCpf;
    }
    /**
     * Set CnpjCpf value
     * @param string $cnpjCpf
     * @return \StructType\DocumentoITD
     */
    public function setCnpjCpf($cnpjCpf = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjCpf) && !is_string($cnpjCpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cnpjCpf)), __LINE__);
        }
        $this->CnpjCpf = $cnpjCpf;
        return $this;
    }
    /**
     * Get DataPagamento value
     * @return string
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\DocumentoITD
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get NumGuiaControle value
     * @return string
     */
    public function getNumGuiaControle()
    {
        return $this->NumGuiaControle;
    }
    /**
     * Set NumGuiaControle value
     * @param string $numGuiaControle
     * @return \StructType\DocumentoITD
     */
    public function setNumGuiaControle($numGuiaControle = null)
    {
        // validation for constraint: string
        if (!is_null($numGuiaControle) && !is_string($numGuiaControle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numGuiaControle)), __LINE__);
        }
        $this->NumGuiaControle = $numGuiaControle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentoITD
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
